// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IDXPluginInfo.C
// ****************************************************************************

#include <IDXPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(IDX,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(IDX,General)

// ****************************************************************************
//  Method: IDXGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IDXGeneralPluginInfo::GetName() const
{
    return "IDX";
}

// ****************************************************************************
//  Method: IDXGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IDXGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: IDXGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IDXGeneralPluginInfo::GetID() const
{
    return "IDX_1.0";
}
// ****************************************************************************
//  Method: IDXGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
IDXGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: IDXGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
IDXGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  IDXGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a IDX database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
IDXGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.idx");
    defaultPatterns.push_back("*.midx");
    defaultPatterns.push_back("*.gidx");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  IDXGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a IDX database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
IDXGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  IDXGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the IDX plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
IDXGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
