// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <IDXPluginInfo.h>
#include <avtIDXFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtIDXOptions.h>

// ****************************************************************************
//  Method:  IDXCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a IDX database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
IDXCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: IDXCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a IDX database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A IDX database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
IDXCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    if (nBlock!=1)
      return NULL;

    // ignore any nBlocks past 1
    int nTimestepGroups = nList / nBlock;
    avtMTMDFileFormat **ffl = new avtMTMDFileFormat*[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtIDXFileFormat(list[i*nBlock], readOptions);
    }
    avtMTMDFileFormatInterface *inter
           = new avtMTMDFileFormatInterface(ffl, nTimestepGroups);

    return new avtGenericDatabase(inter);
}


// ****************************************************************************
//  Method: IDXCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
IDXCommonPluginInfo::GetReadOptions() const
{
    return GetIDXReadOptions();
}

// ****************************************************************************
//  Method: IDXCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
IDXCommonPluginInfo::GetWriteOptions() const
{
    return GetIDXWriteOptions();
}

