// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtHDFSFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_HDFS_FILE_FORMAT_H
#define AVT_HDFS_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <map>
#include <string>
#include <vector>

class avtMaterial;

// ****************************************************************************
//  Class: avtHDFSFileFormat
//
//  Purpose:
//      Reads in HDFS files as a plugin to VisIt.
//
//  Programmer: miller86 -- generated by xml2avt
//  Creation:   Tue Apr 25 16:33:45 PST 2017
//
// ****************************************************************************

class avtHDFSFileFormat : public avtMTMDFileFormat
{
  public:
                       avtHDFSFileFormat(const char *);
    virtual           ~avtHDFSFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    virtual void          *GetAuxiliaryData(const char *var, int timestep, 
                               int domain, const char *type, void *args, 
                               DestructorFunction &);

    virtual void           GetCycles(std::vector<int> &cycles);
    virtual void           GetTimes(std::vector<double> &times);
    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "HDFS"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
    avtMaterial           *GetMaterial(int, int, const char *);

    std::map<std::string,int> varInfoMap;
};


#endif
