// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtH5PartOptions.C                            //
// ************************************************************************* //

#include <avtH5PartOptions.h>

#include <DBOptionsAttributes.h>

#include <visit-config.h>

#include <string>

// ****************************************************************************
//  Function: GetH5PartReadOptions
//
//  Purpose:
//      Creates the options for H5Part readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Feb 9 13:44:50 PST 2010
//
//  Modifications:
//    Gunther H. Weber, Thu Apr  1 18:17:11 PDT 2010
//    Enable domain decomposition per default.
//
// ****************************************************************************

DBOptionsAttributes *
GetH5PartReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Enable domain decomposition", true);
    rv->SetString("Variable path prefix", "Step#");
#ifdef HAVE_LIBFASTQUERY
    rv->SetBool("Use FastBit index", true);
    rv->SetString("FastBit index path prefix", "__H5PartIndex__");
#endif    
    return rv;
}


// ****************************************************************************
//  Function: GetH5PartWriteOptions
//
//  Purpose:
//      Creates the options for H5Part writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Feb 9 13:44:50 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetH5PartWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetString("Variable path prefix", "Step#");
#ifdef HAVE_LIBFASTQUERY
    rv->SetBool("Add FastBit indexing", true);
    rv->SetString("FastBit index path prefix", "__H5PartIndex__");
    // rv->SetBool("Sort variable", "unsorted");
    rv->SetBool("Create a parent file", false);
#endif
    rv->SetString("Parent file name", "visit_ex_db_parent");
    return rv;
}
