// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtGHOSTFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_GHOST_FILE_FORMAT_H
#define AVT_GHOST_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>

// ****************************************************************************
//  Class: avtGHOSTFileFormat
//
//  Purpose:
//      Reads in GHOST (Geophysical High Order Suite for Turbulence)
//      files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Mon May 6 14:21:26 PST 2013
//
// ****************************************************************************

class avtGHOSTFileFormat : public avtSTMDFileFormat
{
  public:
                       avtGHOSTFileFormat(const char *);
    virtual           ~avtGHOSTFileFormat() {}

    virtual const char    *GetType() { return "GHOST"; }
    virtual void           FreeUpResources() {}

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

    void ReadMetaData();
    void GetRange(int dom, int *r0, int *r1);

    bool initialized;
    std::string metaDataFile;
    // vector of (varName, varDataFile).
    std::vector<std::pair<std::string, std::string> > vars;
    int nBlocks, meshSz[3];
};


#endif
