// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FieldViewXDBPluginInfo.C
// ****************************************************************************

#include <FieldViewXDBPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(FieldViewXDB,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(FieldViewXDB,General)

// ****************************************************************************
//  Method: FieldViewXDBGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FieldViewXDBGeneralPluginInfo::GetName() const
{
    return "FieldViewXDB";
}

// ****************************************************************************
//  Method: FieldViewXDBGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FieldViewXDBGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: FieldViewXDBGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FieldViewXDBGeneralPluginInfo::GetID() const
{
    return "FieldViewXDB_1.0";
}
// ****************************************************************************
//  Method: FieldViewXDBGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
FieldViewXDBGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: FieldViewXDBGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
FieldViewXDBGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  FieldViewXDBGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a FieldViewXDB database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
FieldViewXDBGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.xdb");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  FieldViewXDBGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a FieldViewXDB database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
FieldViewXDBGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  FieldViewXDBGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the FieldViewXDB plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
FieldViewXDBGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
