// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtCubeOptions.C                              //
// ************************************************************************* //

#include <avtCubeOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetCubeReadOptions
//
//  Purpose:
//      Creates the options for Cube readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: prabhat -- generated by xml2avt
//  Creation:   Fri Jun 12 09:11:12 PDT 2009
//
//  Programmer: oruebel -- Rename to Cube and removed Walker functionality
//  Modified:   Thu May 12 11:18 PDT 2009
//
//  Programmer: jfavre -- Added a boolean to extend the grid by one cell for CP2K users
//  Modified:   Fri Apr 26 11:12:38 CEST 2013
//
// ****************************************************************************

DBOptionsAttributes *
GetCubeReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

//default value false means this is the unchanged behavior up to version 2.6.2
    rv->SetBool("ExtendVolumeByOneCell", true);
/* EXAMPLE OF OPTIONS
    rv->SetBool("Big Endian", false);
    rv->SetEnum("Dimension", 1);
    vector<string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
    return rv;
}


// ****************************************************************************
//  Function: GetCubeWriteOptions
//
//  Purpose:
//      Creates the options for Cube writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: prabhat -- generated by xml2avt
//  Creation:   Fri Jun 12 09:11:12 PDT 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetCubeWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
