// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <CubePluginInfo.h>
#include <avtCubeFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtCubeOptions.h>

// ****************************************************************************
//  Method:  CubeCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Cube database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
CubeCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method: CubeCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a Cube database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Cube database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
CubeCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    int nTimestepGroups = nList / nBlock;
    avtMTSDFileFormat ***ffl = new avtMTSDFileFormat**[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtMTSDFileFormat*[nBlock];
        for (int j = 0; j < nBlock; j++)
        {
            ffl[i][j] = new avtCubeFileFormat(list[i*nBlock + j], readOptions);
        }
    }
    avtMTSDFileFormatInterface *inter
           = new avtMTSDFileFormatInterface(ffl, nTimestepGroups, nBlock);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: CubeCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
CubeCommonPluginInfo::GetReadOptions() const
{
    return GetCubeReadOptions();
}

// ****************************************************************************
//  Method: CubeCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
CubeCommonPluginInfo::GetWriteOptions() const
{
    return GetCubeWriteOptions();
}

