// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtCosmosPPFileFormat.h                          //
// ************************************************************************* //

#ifndef AVT_COSMOS_PP_FILE_FORMAT_H
#define AVT_COSMOS_PP_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>
#include <string>
#include <visitstream.h>

class vtkUnstructuredGrid;


// ****************************************************************************
//  Class: avtCosmosPPFileFormat
//
//  Purpose:
//      Reads in CosmosPP files as a plugin to VisIt.
//
//  Programmer: panninos -- generated by xml2avt
//  Creation:   Wed Mar 16 09:14:06 PDT 2016
//
// ****************************************************************************

class avtCosmosPPFileFormat : public avtMTMDFileFormat
{
  public:
                          avtCosmosPPFileFormat(const char *);
    virtual              ~avtCosmosPPFileFormat();

    virtual const char   *GetType(void) { return "Cosmos++ File Format"; };
    
    virtual void          GetCycles(std::vector<int> &);
    virtual void          GetTimes(std::vector<double> &);
    virtual int           GetNTimesteps(void);
 
    virtual vtkDataSet   *GetMesh(int, int, const char *);
    virtual vtkDataArray *GetVar(int, int, const char *);
    virtual vtkDataArray *GetVectorVar(int, int, const char *);

    virtual void          FreeUpResources(void); 
    virtual void          PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

  protected:
    std::string                         dirname;
    
    std::vector<int>                    cycles;
    std::vector<double>                 times;
    int                                 rank;
    int                                 ndomains;
    int                                 ntimesteps;
    int                                 nscalars;
    int                                 nvectors;
    bool                                haveIssuedWarning;

    std::vector<std::string>            scalarVarNames;
    std::vector<std::string>            vectorVarNames;
    std::vector<std::string>            proc_names;
    std::vector<std::string>            dump_names;
    std::vector<std::string>            grid_dump_names;

    int                                       nParticleTypes;
    std::vector<std::string>                  particleTypeNames;
    std::vector<std::vector<std::string> >    particleScalarVarNames;
    std::vector<std::vector<std::string> >    particleVectorVarNames;

    std::vector<std::vector<bool> >                   readDataset;
    std::vector<std::vector<vtkUnstructuredGrid *> >  dataset;

    std::vector<std::vector<std::vector<vtkUnstructuredGrid *> > >  particleDataset;

    void ReadDataset(int, int);

    void ReadString(ifstream &ifile, std::string &str);
};

#endif
