// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CarpetHDF5PluginInfo.C
// ****************************************************************************

#include <CarpetHDF5PluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(CarpetHDF5,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(CarpetHDF5,General)

// ****************************************************************************
//  Method: CarpetHDF5GeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CarpetHDF5GeneralPluginInfo::GetName() const
{
    return "CarpetHDF5";
}

// ****************************************************************************
//  Method: CarpetHDF5GeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CarpetHDF5GeneralPluginInfo::GetVersion() const
{
    return "2.1";
}

// ****************************************************************************
//  Method: CarpetHDF5GeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CarpetHDF5GeneralPluginInfo::GetID() const
{
    return "CarpetHDF5_2.1";
}
// ****************************************************************************
//  Method: CarpetHDF5GeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CarpetHDF5GeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: CarpetHDF5GeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CarpetHDF5GeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  CarpetHDF5GeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a CarpetHDF5 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
CarpetHDF5GeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.h5");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  CarpetHDF5GeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a CarpetHDF5 database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
CarpetHDF5GeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  CarpetHDF5GeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the CarpetHDF5 plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
CarpetHDF5GeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
