// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.


// ****************************************************************************
//  avtAVSucdFileFormat.h
// ****************************************************************************

#ifndef AVT_AVSucd_FILE_FORMAT_H
#define AVT_AVSucd_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>

#include <map>
#include <string>

class VisItAVSucdReader;

// ****************************************************************************
//  Class: avtAVSucdFileFormat
//
//  Purpose:
//      Reads in AVSucd files as a plugin to VisIt.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue Feb 4 11:14:47 PDT 2020
//
// ****************************************************************************

class avtAVSucdFileFormat : public avtSTSDFileFormat
{
  public:
                       avtAVSucdFileFormat(const char *filename);
    virtual           ~avtAVSucdFileFormat();

    virtual const char    *GetType(void)   { return "AVSucd"; }
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);

  protected:

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

  private:

    VisItAVSucdReader        *reader;
    std::map<std::string, bool> nodeCentered;

    void                      ReadInData();
    bool                      haveReadInData;
};


#endif
