// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ANSYSPluginInfo.C
// ****************************************************************************

#include <ANSYSPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ANSYS,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(ANSYS,General)

// ****************************************************************************
//  Method: ANSYSGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ANSYSGeneralPluginInfo::GetName() const
{
    return "ANSYS";
}

// ****************************************************************************
//  Method: ANSYSGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ANSYSGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ANSYSGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ANSYSGeneralPluginInfo::GetID() const
{
    return "ANSYS_1.0";
}
// ****************************************************************************
//  Method: ANSYSGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ANSYSGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ANSYSGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ANSYSGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  ANSYSGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a ANSYS database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ANSYSGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.inp");
    defaultPatterns.push_back("*.cdb");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ANSYSGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a ANSYS database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ANSYSGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ANSYSGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the ANSYS plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ANSYSGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
