// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtADIOS2FileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_MEUMMAPS_FILE_FORMAT_H
#define AVT_MEUMMAPS_FILE_FORMAT_H

#include <avtMTMDFileFormatInterface.h>
#include <avtMTMDFileFormat.h>

#include <adios2.h>
#include <vector>
#include <map>

// ****************************************************************************
//  Class: avtADIOS2FileFormat
//
//  Purpose:
//      Reads in ADIOS2 files as a plugin to VisIt.
//
//  Programmer: dpn -- generated by xml2avt
//  Creation:   Tue Sep 11 13:23:54 PST 2018
//
// ****************************************************************************

class avtMEUMMAPSFileFormat : public avtMTMDFileFormat
{
  public:
    static bool        Identify(const char *fname);
    static avtFileFormatInterface *CreateInterface(const char *const *list,
                                                   int nList,
                                                   int nBlock);

                       avtMEUMMAPSFileFormat(const char *);

    // interface creator with first file already opened
    static avtFileFormatInterface *CreateInterfaceADIOS2(
            const char *const *list,
            int nList,
            int nBlock,
            std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader, 
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes
            );

    // constructor with already-opened stream
    avtMEUMMAPSFileFormat(std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader,
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes,
            const char *);

    virtual           ~avtMEUMMAPSFileFormat() {}

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int domain,
    //                                     const char *type, void *args,
    //                                     DestructorFunction &);
    //

    //
    // If you know the cycle number, overload this function.
    // Otherwise, VisIt will make up a reasonable one for you.
    //
    // virtual int         GetCycle(void);
    //
    virtual int            GetNTimesteps() {return 1;}
    virtual const char    *GetType(void)   {return "MEUMMAPS";}
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

    static bool IdentifyADIOS2(
                   std::map<std::string, adios2::Params> &variables, 
                   std::map<std::string, adios2::Params> &attributes);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    std::shared_ptr<adios2::ADIOS> adios;
    adios2::IO io;
    adios2::Engine reader;
    std::map<std::string, adios2::Params> variables;
    std::map<std::string, std::pair<int,std::string>> meshInfo;
    std::vector<int> meshSz;
    std::vector<double> origin, spacing;
    double dT;
    int numTimeSteps;

    std::vector<int> startIdx, endIdx;

    void GetDomainIdx(int domain, int &i0, int &i1);
};


#endif
