// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtGTCFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_GTC_FILE_FORMAT_H
#define AVT_GTC_FILE_FORMAT_H

#include <avtMTSDFileFormat.h>

#include <vector>
#include <memory>
#include <map>
#include <adios2.h>


class vtkUnstructuredGrid;
class vtkPoints;

// ****************************************************************************
//  Class: avtGTCFileFormat
//
//  Purpose:
//      Reads in GTC files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Thu Apr 12 08:39:47 PDT 2018
//
// ****************************************************************************

class avtGTCFileFormat : public avtMTSDFileFormat
{
  public:
    static bool        Identify(const char *fname);
    static avtFileFormatInterface *CreateInterface(const char *const *list,
                                                   int nList,
                                                   int nBlock);

                       avtGTCFileFormat(const char *);

    // interface creator with first file already opened
    static avtFileFormatInterface *CreateInterfaceADIOS2(
            const char *const *list,
            int nList,
            int nBlock,
            std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader, 
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes
            );

    // constructor with already-opened stream
    avtGTCFileFormat(std::shared_ptr<adios2::ADIOS> adios,
            adios2::Engine &reader,
            adios2::IO &io,
            std::map<std::string, adios2::Params> &variables,
            std::map<std::string, adios2::Params> &attributes,
            const char *);

    virtual           ~avtGTCFileFormat();

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep,
    //                                     const char *type, void *args,
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    virtual void        GetCycles(std::vector<int> &c);
    virtual void        GetTimes(std::vector<double> &t);

    virtual int            GetNTimesteps();

    virtual const char    *GetType()   { return "GTC"; };
    virtual void           FreeUpResources();

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataSet    *GetPtMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

    static bool IdentifyADIOS2(
                   std::map<std::string, adios2::Params> &variables, 
                   std::map<std::string, adios2::Params> &attributes);

  protected:
    // DATA MEMBERS
    vtkUnstructuredGrid * CreateMesh(bool xyzMesh);

    std::shared_ptr<adios2::ADIOS> adios;
    adios2::IO io;
    adios2::Engine reader;
    std::map<std::string, adios2::Params> variables, attributes;
    std::map<std::string, std::pair<int,std::string>> meshInfo;

    vtkUnstructuredGrid *grid, *ptGrid, *cylGrid;
    int numTimeSteps;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
};


#endif
