// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtLAMMPSFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_LAMMPS_FILE_FORMAT_H
#define AVT_LAMMPS_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>

class avtFileFormatInterface;
class ADIOSFileObject;

// ****************************************************************************
//  Class: avtLAMMPSFileFormat
//
//  Purpose:
//      Reads in LAMMPS files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Wed Oct 29 14:12:25 PST 2014
//
// ****************************************************************************

class avtLAMMPSFileFormat : public avtMTMDFileFormat
{
  public:
    static bool        Identify(const char *fname);
    static avtFileFormatInterface *CreateInterface(const char *const *list,
                                                   int nList,
                                                   int nBlock);

                       avtLAMMPSFileFormat(const char *);
    virtual           ~avtLAMMPSFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep, 
    //                                     int domain, const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    // virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "LAMMPS"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

  protected:
    ADIOSFileObject *file;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
};


#endif
