// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ADIOSPluginInfo.h>
#include <avtADIOSFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ADIOSCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ADIOS database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
ADIOSCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: ADIOSCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a ADIOS database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ADIOS database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
ADIOSCommonPluginInfo::SetupDatabase(const char *const *list,
                                     int nList,
                                     int nBlock)
{
    avtDatabase *db = 0;

    //
    // Create a file format interface.
    //
    avtFileFormatInterface *ffi = ADIOS_CreateFileFormatInterface(list,
                                                                  nList,
                                                                  nBlock);

    //
    // If we created a file format interface, try creating a database.
    //
    if (ffi)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(ffi);
        }
        CATCH(VisItException)
        {
            delete ffi;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;
}

