# a windows 10 system

include(${VISIT_SOURCE_DIR}/config-site/windows.cmake)

# disable some warnings
# 4244 conversion double to float etc
# 4305 truncation from 'double' to 'float', etc
# 4800 'int' forcing value to bool (performance warning)
ADD_DEFINITIONS(/wd4244 /wd4305 /wd4800)

VISIT_OPTION_DEFAULT(VISIT_INSTALL_PROFILES_TO_HOSTS "llnl" TYPE STRING)
VISIT_OPTION_DEFAULT(VISIT_INSTALL_THIRD_PARTY ON TYPE BOOL)
VISIT_OPTION_DEFAULT(VISIT_PARALLEL OFF TYPE BOOL)
VISIT_OPTION_DEFAULT(VISIT_WINDOWS_APPLICATION OFF TYPE BOOL)
VISIT_OPTION_DEFAULT(VISIT_NO_ALLBUILD ON TYPE BOOL)
VISIT_OPTION_DEFAULT(VISIT_CREATE_XMLTOOLS_GEN_TARGETS OFF TYPE BOOL)

SET(CMAKE_SUPPRESS_REGENERATION TRUE)
SET(CMAKE_SKIP_INSTALL_ALL_DEPENDENCY TRUE)

if(USE_REDUCED_BUILD) # this is just a var I create when I need it
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_ANNOTATION_TOOLS OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_DATAGEN OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_DATA_MANUAL_EXAMPLES OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_DIAGNOSTICS OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_EXAMPLES OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_LIBSIM OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_MANUALS OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_ENABLE_SILO_TOOLS OFF TYPE BOOL)

  VISIT_OPTION_DEFAULT(VISIT_BUILD_ALL_PLUGINS OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_CREATE_XMLTOOLS_GEN_TARGETS OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_PARALLEL OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_SPHINX OFF TYPE BOOL)
  VISIT_OPTION_DEFAULT(VISIT_WINDOWS_APPLICATION OFF TYPE BOOL)

  VISIT_OPTION_DEFAULT(VISIT_SELECTED_DATABASE_PLUGINS "VTK;Silo" TYPE STRING)
  VISIT_OPTION_DEFAULT(VISIT_SELECTED_PLOT_PLUGINS "Pseudocolor;Curve" TYPE STRING)
  VISIT_OPTION_DEFAULT(VISIT_SELECTED_OPERATOR_PLUGINS "Slice;Lineout" TYPE STRING)
  
endif()
