// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef VISUALCUELIST_H
#define VISUALCUELIST_H
#include <state_exports.h>
#include <AttributeSubject.h>

class VisualCueInfo;

// ****************************************************************************
// Class: VisualCueList
//
// Purpose:
//    container object for shipping vectors of visual cues
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API VisualCueList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    VisualCueList();
    VisualCueList(const VisualCueList &obj);
protected:
    // These constructors are for objects derived from this class
    VisualCueList(private_tmfs_t tmfs);
    VisualCueList(const VisualCueList &obj, private_tmfs_t tmfs);
public:
    virtual ~VisualCueList();

    virtual VisualCueList& operator = (const VisualCueList &obj);
    virtual bool operator == (const VisualCueList &obj) const;
    virtual bool operator != (const VisualCueList &obj) const;
private:
    void Init();
    void Copy(const VisualCueList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCues();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetCues() const;
          AttributeGroupVector &GetCues();


    // Attributegroup convenience methods
    void AddCues(const VisualCueInfo &);
    void ClearCues();
    void RemoveCues(int i);
    int  GetNumCues() const;
    VisualCueInfo &GetCues(int i);
    const VisualCueInfo &GetCues(int i) const;

    VisualCueInfo &operator [] (int i);
    const VisualCueInfo &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void SetFrom(const std::vector<const VisualCueInfo*>& cues);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_cues = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector cues;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VISUALCUELIST_TMFS "a*"

#endif
