// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef VIEWERCLIENTINFORMATION_H
#define VIEWERCLIENTINFORMATION_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

class ViewerClientInformationElement;

// ****************************************************************************
// Class: ViewerClientInformation
//
// Purpose:
//    This class contains information generated for each client
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ViewerClientInformation : public AttributeSubject
{
public:
    enum OutputFormat
    {
        None,
        Image,
        BMP,
        PNG,
        JPEG,
        Data,
        VTK,
        X3D,
        UserData,
        JSON,
        Message
    };

    // These constructors are for objects of this class
    ViewerClientInformation();
    ViewerClientInformation(const ViewerClientInformation &obj);
protected:
    // These constructors are for objects derived from this class
    ViewerClientInformation(private_tmfs_t tmfs);
    ViewerClientInformation(const ViewerClientInformation &obj, private_tmfs_t tmfs);
public:
    virtual ~ViewerClientInformation();

    virtual ViewerClientInformation& operator = (const ViewerClientInformation &obj);
    virtual bool operator == (const ViewerClientInformation &obj) const;
    virtual bool operator != (const ViewerClientInformation &obj) const;
private:
    void Init();
    void Copy(const ViewerClientInformation &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVars();
    void SelectSupportedFormats();

    // Property setting methods
    void SetSupportedFormats(const stringVector &supportedFormats_);

    // Property getting methods
    const AttributeGroupVector &GetVars() const;
          AttributeGroupVector &GetVars();
    const stringVector &GetSupportedFormats() const;
          stringVector &GetSupportedFormats();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddVars(const ViewerClientInformationElement &);
    void ClearVars();
    void RemoveVars(int i);
    int  GetNumVars() const;
    ViewerClientInformationElement &GetVars(int i);
    const ViewerClientInformationElement &GetVars(int i) const;

    ViewerClientInformationElement &operator [] (int i);
    const ViewerClientInformationElement &operator [] (int i) const;

    // Enum conversion functions
    static std::string OutputFormat_ToString(OutputFormat);
    static bool OutputFormat_FromString(const std::string &, OutputFormat &);
protected:
    static std::string OutputFormat_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_vars = 0,
        ID_supportedFormats,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector vars;
    stringVector         supportedFormats;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VIEWERCLIENTINFORMATION_TMFS "a*s*"

#endif
