// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ViewerClientInformation.h>
#include <DataNode.h>
#include <ViewerClientInformationElement.h>

//
// Enum conversion methods for ViewerClientInformation::OutputFormat
//

static const char *OutputFormat_strings[] = {
"None", "Image", "BMP",
"PNG", "JPEG", "Data",
"VTK", "X3D", "UserData",
"JSON", "Message"};

std::string
ViewerClientInformation::OutputFormat_ToString(ViewerClientInformation::OutputFormat t)
{
    int index = int(t);
    if(index < 0 || index >= 11) index = 0;
    return OutputFormat_strings[index];
}

std::string
ViewerClientInformation::OutputFormat_ToString(int t)
{
    int index = (t < 0 || t >= 11) ? 0 : t;
    return OutputFormat_strings[index];
}

bool
ViewerClientInformation::OutputFormat_FromString(const std::string &s, ViewerClientInformation::OutputFormat &val)
{
    val = ViewerClientInformation::None;
    for(int i = 0; i < 11; ++i)
    {
        if(s == OutputFormat_strings[i])
        {
            val = (OutputFormat)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ViewerClientInformation::ViewerClientInformation
//
// Purpose:
//   Init utility for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void ViewerClientInformation::Init()
{
    supportedFormats.push_back("None");
    supportedFormats.push_back("Image");
    supportedFormats.push_back("BMP");
    supportedFormats.push_back("PNG");
    supportedFormats.push_back("JPEG");
    supportedFormats.push_back("Data");
    supportedFormats.push_back("VTK");
    supportedFormats.push_back("X3D");
    supportedFormats.push_back("UserData");
    supportedFormats.push_back("JSON");
    supportedFormats.push_back("Message");

    ViewerClientInformation::SelectAll();
}

// ****************************************************************************
// Method: ViewerClientInformation::ViewerClientInformation
//
// Purpose:
//   Copy utility for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void ViewerClientInformation::Copy(const ViewerClientInformation &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the vars field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = vars.begin(); pos != vars.end(); ++pos)
        delete *pos;
    vars.clear();
    if(obj.vars.size() > 0)
        vars.reserve(obj.vars.size());
    // Duplicate the vars from obj.
    for(pos = obj.vars.begin(); pos != obj.vars.end(); ++pos)
    {
        ViewerClientInformationElement *oldViewerClientInformationElement = (ViewerClientInformationElement *)(*pos);
        ViewerClientInformationElement *newViewerClientInformationElement = new ViewerClientInformationElement(*oldViewerClientInformationElement);
        vars.push_back(newViewerClientInformationElement);
    }

    supportedFormats = obj.supportedFormats;

    ViewerClientInformation::SelectAll();
}

// Type map format string
const char *ViewerClientInformation::TypeMapFormatString = VIEWERCLIENTINFORMATION_TMFS;
const AttributeGroup::private_tmfs_t ViewerClientInformation::TmfsStruct = {VIEWERCLIENTINFORMATION_TMFS};


// ****************************************************************************
// Method: ViewerClientInformation::ViewerClientInformation
//
// Purpose:
//   Default constructor for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformation::ViewerClientInformation() :
    AttributeSubject(ViewerClientInformation::TypeMapFormatString)
{
    ViewerClientInformation::Init();
}

// ****************************************************************************
// Method: ViewerClientInformation::ViewerClientInformation
//
// Purpose:
//   Constructor for the derived classes of ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformation::ViewerClientInformation(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    ViewerClientInformation::Init();
}

// ****************************************************************************
// Method: ViewerClientInformation::ViewerClientInformation
//
// Purpose:
//   Copy constructor for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformation::ViewerClientInformation(const ViewerClientInformation &obj) :
    AttributeSubject(ViewerClientInformation::TypeMapFormatString)
{
    ViewerClientInformation::Copy(obj);
}

// ****************************************************************************
// Method: ViewerClientInformation::ViewerClientInformation
//
// Purpose:
//   Copy constructor for derived classes of the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformation::ViewerClientInformation(const ViewerClientInformation &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    ViewerClientInformation::Copy(obj);
}

// ****************************************************************************
// Method: ViewerClientInformation::~ViewerClientInformation
//
// Purpose:
//   Destructor for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformation::~ViewerClientInformation()
{
    AttributeGroupVector::iterator pos;

    // Destroy the vars field.
    for(pos = vars.begin(); pos != vars.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: ViewerClientInformation::operator =
//
// Purpose:
//   Assignment operator for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformation&
ViewerClientInformation::operator = (const ViewerClientInformation &obj)
{
    if (this == &obj) return *this;

    ViewerClientInformation::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ViewerClientInformation::operator ==
//
// Purpose:
//   Comparison operator == for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ViewerClientInformation::operator == (const ViewerClientInformation &obj) const
{
    bool vars_equal = (obj.vars.size() == vars.size());
    for(size_t i = 0; (i < vars.size()) && vars_equal; ++i)
    {
        // Make references to ViewerClientInformationElement from AttributeGroup *.
        const ViewerClientInformationElement &vars1 = *((const ViewerClientInformationElement *)(vars[i]));
        const ViewerClientInformationElement &vars2 = *((const ViewerClientInformationElement *)(obj.vars[i]));
        vars_equal = (vars1 == vars2);
    }

    // Create the return value
    return (vars_equal &&
            (supportedFormats == obj.supportedFormats));
}

// ****************************************************************************
// Method: ViewerClientInformation::operator !=
//
// Purpose:
//   Comparison operator != for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ViewerClientInformation::operator != (const ViewerClientInformation &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewerClientInformation::TypeName
//
// Purpose:
//   Type name method for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
ViewerClientInformation::TypeName() const
{
    return "ViewerClientInformation";
}

// ****************************************************************************
// Method: ViewerClientInformation::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ViewerClientInformation::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewerClientInformation *tmp = (const ViewerClientInformation *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewerClientInformation::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
ViewerClientInformation::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewerClientInformation(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: ViewerClientInformation::NewInstance
//
// Purpose:
//   NewInstance method for the ViewerClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
ViewerClientInformation::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewerClientInformation(*this);
    else
        retval = new ViewerClientInformation;

    return retval;
}

// ****************************************************************************
// Method: ViewerClientInformation::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ViewerClientInformation::SelectAll()
{
    Select(ID_vars,             (void *)&vars);
    Select(ID_supportedFormats, (void *)&supportedFormats);
}

// ****************************************************************************
// Method: ViewerClientInformation::CreateSubAttributeGroup
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup *
ViewerClientInformation::CreateSubAttributeGroup(int)
{
    return new ViewerClientInformationElement;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientInformation::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ViewerClientInformation::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ViewerClientInformation defaultObject;
    bool addToParent = false;
    // Create a node for ViewerClientInformation.
    DataNode *node = new DataNode("ViewerClientInformation");

    if(completeSave || !FieldsEqual(ID_vars, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < vars.size(); ++i)
            vars[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_supportedFormats, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("supportedFormats", supportedFormats));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ViewerClientInformation::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ViewerClientInformation::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewerClientInformation");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;

    // Clear all the ViewerClientInformationElements if we got any.
    bool clearedVars = false;
    // Go through all of the children and construct a new
    // ViewerClientInformationElement for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("ViewerClientInformationElement"))
            {
                if (!clearedVars)
                {
                    ClearVars();
                    clearedVars = true;
                }
                ViewerClientInformationElement temp;
                temp.SetFromNode(children[i]);
                AddVars(temp);
            }
        }
    }

    if((node = searchNode->GetNode("supportedFormats")) != 0)
        SetSupportedFormats(node->AsStringVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerClientInformation::SetSupportedFormats(const stringVector &supportedFormats_)
{
    supportedFormats = supportedFormats_;
    Select(ID_supportedFormats, (void *)&supportedFormats);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
ViewerClientInformation::GetVars() const
{
    return vars;
}

AttributeGroupVector &
ViewerClientInformation::GetVars()
{
    return vars;
}

const stringVector &
ViewerClientInformation::GetSupportedFormats() const
{
    return supportedFormats;
}

stringVector &
ViewerClientInformation::GetSupportedFormats()
{
    return supportedFormats;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerClientInformation::SelectVars()
{
    Select(ID_vars, (void *)&vars);
}

void
ViewerClientInformation::SelectSupportedFormats()
{
    Select(ID_supportedFormats, (void *)&supportedFormats);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientInformation::AddVars
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ViewerClientInformation::AddVars(const ViewerClientInformationElement &obj)
{
    ViewerClientInformationElement *newViewerClientInformationElement = new ViewerClientInformationElement(obj);
    vars.push_back(newViewerClientInformationElement);

    // Indicate that things have changed by selecting it.
    Select(ID_vars, (void *)&vars);
}

// ****************************************************************************
// Method: ViewerClientInformation::ClearVars
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ViewerClientInformation::ClearVars()
{
    AttributeGroupVector::iterator pos;

    for(pos = vars.begin(); pos != vars.end(); ++pos)
        delete *pos;
    vars.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_vars, (void *)&vars);
}

// ****************************************************************************
// Method: ViewerClientInformation::RemoveVars
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ViewerClientInformation::RemoveVars(int index)
{
    AttributeGroupVector::iterator pos = vars.begin();

    // Iterate through the vector "index" times.
    for(int i = 0; i < index; ++i)
        if(pos != vars.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != vars.end())
    {
        delete *pos;
        vars.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_vars, (void *)&vars);
}

// ****************************************************************************
// Method: ViewerClientInformation::GetNumVars
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
ViewerClientInformation::GetNumVars() const
{
    return (int)vars.size();
}

// ****************************************************************************
// Method: ViewerClientInformation::GetVars
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformationElement &
ViewerClientInformation::GetVars(int i)
{
    return *((ViewerClientInformationElement *)vars[i]);
}

// ****************************************************************************
// Method: ViewerClientInformation::GetVars
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const ViewerClientInformationElement &
ViewerClientInformation::GetVars(int i) const
{
    return *((ViewerClientInformationElement *)vars[i]);
}

// ****************************************************************************
// Method: ViewerClientInformation::operator []
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ViewerClientInformationElement &
ViewerClientInformation::operator [] (int i)
{
    return *((ViewerClientInformationElement *)vars[i]);
}

// ****************************************************************************
// Method: ViewerClientInformation::operator []
//
// Purpose:
//   This class contains information generated for each client
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const ViewerClientInformationElement &
ViewerClientInformation::operator [] (int i) const
{
    return *((ViewerClientInformationElement *)vars[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerClientInformation::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
ViewerClientInformation::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_vars:             return "vars";
    case ID_supportedFormats: return "supportedFormats";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerClientInformation::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
ViewerClientInformation::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_vars:             return FieldType_attVector;
    case ID_supportedFormats: return FieldType_stringVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewerClientInformation::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
ViewerClientInformation::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_vars:             return "attVector";
    case ID_supportedFormats: return "stringVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerClientInformation::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ViewerClientInformation::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ViewerClientInformation &obj = *((const ViewerClientInformation*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_vars:
        {  // new scope
        bool vars_equal = (obj.vars.size() == vars.size());
        for(size_t i = 0; (i < vars.size()) && vars_equal; ++i)
        {
            // Make references to ViewerClientInformationElement from AttributeGroup *.
            const ViewerClientInformationElement &vars1 = *((const ViewerClientInformationElement *)(vars[i]));
            const ViewerClientInformationElement &vars2 = *((const ViewerClientInformationElement *)(obj.vars[i]));
            vars_equal = (vars1 == vars2);
        }

        retval = vars_equal;
        }
        break;
    case ID_supportedFormats:
        {  // new scope
        retval = (supportedFormats == obj.supportedFormats);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

