// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef TIMEFORMAT_H
#define TIMEFORMAT_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: TimeFormat
//
// Purpose:
//    This class encapsulates the attributes needed to format time.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API TimeFormat : public AttributeSubject
{
public:
    enum DisplayMode
    {
        Cycles,
        Times,
        CyclesAndTimes
    };

    // These constructors are for objects of this class
    TimeFormat();
    TimeFormat(const TimeFormat &obj);
protected:
    // These constructors are for objects derived from this class
    TimeFormat(private_tmfs_t tmfs);
    TimeFormat(const TimeFormat &obj, private_tmfs_t tmfs);
public:
    virtual ~TimeFormat();

    virtual TimeFormat& operator = (const TimeFormat &obj);
    virtual bool operator == (const TimeFormat &obj) const;
    virtual bool operator != (const TimeFormat &obj) const;
private:
    void Init();
    void Copy(const TimeFormat &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetDisplayMode(DisplayMode displayMode_);
    void SetPrecision(int precision_);

    // Property getting methods
    DisplayMode GetDisplayMode() const;
    int GetPrecision() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string DisplayMode_ToString(DisplayMode);
    static bool DisplayMode_FromString(const std::string &, DisplayMode &);
protected:
    static std::string DisplayMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_displayMode = 0,
        ID_precision,
        ID__LAST
    };

private:
    int displayMode;
    int precision;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define TIMEFORMAT_TMFS "ii"

#endif
