// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SurfaceFilterAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SurfaceFilterAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
SurfaceFilterAttributes::Scaling_ToString(SurfaceFilterAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
SurfaceFilterAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
SurfaceFilterAttributes::Scaling_FromString(const std::string &s, SurfaceFilterAttributes::Scaling &val)
{
    val = SurfaceFilterAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfaceFilterAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
SurfaceFilterAttributes::LimitsMode_ToString(SurfaceFilterAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
SurfaceFilterAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
SurfaceFilterAttributes::LimitsMode_FromString(const std::string &s, SurfaceFilterAttributes::LimitsMode &val)
{
    val = SurfaceFilterAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfaceFilterAttributes::ScalingMode
//

static const char *ScalingMode_strings[] = {
"Never", "Auto", "Always"
};

std::string
SurfaceFilterAttributes::ScalingMode_ToString(SurfaceFilterAttributes::ScalingMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ScalingMode_strings[index];
}

std::string
SurfaceFilterAttributes::ScalingMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ScalingMode_strings[index];
}

bool
SurfaceFilterAttributes::ScalingMode_FromString(const std::string &s, SurfaceFilterAttributes::ScalingMode &val)
{
    val = SurfaceFilterAttributes::Never;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ScalingMode_strings[i])
        {
            val = (ScalingMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose:
//   Init utility for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SurfaceFilterAttributes::Init()
{
    limitsMode = OriginalData;
    minFlag = false;
    maxFlag = false;
    scaling = Linear;
    skewFactor = 1;
    min = 0;
    max = 1;
    zeroFlag = false;
    useXYLimits = Auto;
    generateNodalOutput = true;

    SurfaceFilterAttributes::SelectAll();
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose:
//   Copy utility for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SurfaceFilterAttributes::Copy(const SurfaceFilterAttributes &obj)
{
    limitsMode = obj.limitsMode;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    min = obj.min;
    max = obj.max;
    zeroFlag = obj.zeroFlag;
    variable = obj.variable;
    useXYLimits = obj.useXYLimits;
    generateNodalOutput = obj.generateNodalOutput;

    SurfaceFilterAttributes::SelectAll();
}

// Type map format string
const char *SurfaceFilterAttributes::TypeMapFormatString = SURFACEFILTERATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SurfaceFilterAttributes::TmfsStruct = {SURFACEFILTERATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose:
//   Default constructor for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SurfaceFilterAttributes::SurfaceFilterAttributes() :
    AttributeSubject(SurfaceFilterAttributes::TypeMapFormatString),
    variable("default")
{
    SurfaceFilterAttributes::Init();
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose:
//   Constructor for the derived classes of SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SurfaceFilterAttributes::SurfaceFilterAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    variable("default")
{
    SurfaceFilterAttributes::Init();
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose:
//   Copy constructor for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SurfaceFilterAttributes::SurfaceFilterAttributes(const SurfaceFilterAttributes &obj) :
    AttributeSubject(SurfaceFilterAttributes::TypeMapFormatString)
{
    SurfaceFilterAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SurfaceFilterAttributes
//
// Purpose:
//   Copy constructor for derived classes of the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SurfaceFilterAttributes::SurfaceFilterAttributes(const SurfaceFilterAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SurfaceFilterAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::~SurfaceFilterAttributes
//
// Purpose:
//   Destructor for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SurfaceFilterAttributes::~SurfaceFilterAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::operator =
//
// Purpose:
//   Assignment operator for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SurfaceFilterAttributes&
SurfaceFilterAttributes::operator = (const SurfaceFilterAttributes &obj)
{
    if (this == &obj) return *this;

    SurfaceFilterAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfaceFilterAttributes::operator == (const SurfaceFilterAttributes &obj) const
{
    // Create the return value
    return ((limitsMode == obj.limitsMode) &&
            (minFlag == obj.minFlag) &&
            (maxFlag == obj.maxFlag) &&
            (scaling == obj.scaling) &&
            (skewFactor == obj.skewFactor) &&
            (min == obj.min) &&
            (max == obj.max) &&
            (zeroFlag == obj.zeroFlag) &&
            (variable == obj.variable) &&
            (useXYLimits == obj.useXYLimits) &&
            (generateNodalOutput == obj.generateNodalOutput));
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfaceFilterAttributes::operator != (const SurfaceFilterAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::TypeName
//
// Purpose:
//   Type name method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
SurfaceFilterAttributes::TypeName() const
{
    return "SurfaceFilterAttributes";
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfaceFilterAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SurfaceFilterAttributes *tmp = (const SurfaceFilterAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SurfaceFilterAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SurfaceFilterAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the SurfaceFilterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SurfaceFilterAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SurfaceFilterAttributes(*this);
    else
        retval = new SurfaceFilterAttributes;

    return retval;
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SurfaceFilterAttributes::SelectAll()
{
    Select(ID_limitsMode,          (void *)&limitsMode);
    Select(ID_minFlag,             (void *)&minFlag);
    Select(ID_maxFlag,             (void *)&maxFlag);
    Select(ID_scaling,             (void *)&scaling);
    Select(ID_skewFactor,          (void *)&skewFactor);
    Select(ID_min,                 (void *)&min);
    Select(ID_max,                 (void *)&max);
    Select(ID_zeroFlag,            (void *)&zeroFlag);
    Select(ID_variable,            (void *)&variable);
    Select(ID_useXYLimits,         (void *)&useXYLimits);
    Select(ID_generateNodalOutput, (void *)&generateNodalOutput);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceFilterAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfaceFilterAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SurfaceFilterAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SurfaceFilterAttributes.
    DataNode *node = new DataNode("SurfaceFilterAttributes");

    if(completeSave || !FieldsEqual(ID_limitsMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(ID_minFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(ID_maxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(ID_scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", Scaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(ID_skewFactor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("skewFactor", skewFactor));
    }

    if(completeSave || !FieldsEqual(ID_min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(ID_max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(ID_zeroFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zeroFlag", zeroFlag));
    }

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }

    if(completeSave || !FieldsEqual(ID_useXYLimits, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useXYLimits", ScalingMode_ToString(useXYLimits)));
    }

    if(completeSave || !FieldsEqual(ID_generateNodalOutput, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("generateNodalOutput", generateNodalOutput));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SurfaceFilterAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SurfaceFilterAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetScaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("skewFactor")) != 0)
        SetSkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("zeroFlag")) != 0)
        SetZeroFlag(node->AsBool());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
    if((node = searchNode->GetNode("useXYLimits")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetUseXYLimits(ScalingMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ScalingMode value;
            if(ScalingMode_FromString(node->AsString(), value))
                SetUseXYLimits(value);
        }
    }
    if((node = searchNode->GetNode("generateNodalOutput")) != 0)
        SetGenerateNodalOutput(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceFilterAttributes::SetLimitsMode(SurfaceFilterAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(ID_limitsMode, (void *)&limitsMode);
}

void
SurfaceFilterAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(ID_minFlag, (void *)&minFlag);
}

void
SurfaceFilterAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(ID_maxFlag, (void *)&maxFlag);
}

void
SurfaceFilterAttributes::SetScaling(SurfaceFilterAttributes::Scaling scaling_)
{
    scaling = scaling_;
    Select(ID_scaling, (void *)&scaling);
}

void
SurfaceFilterAttributes::SetSkewFactor(double skewFactor_)
{
    skewFactor = skewFactor_;
    Select(ID_skewFactor, (void *)&skewFactor);
}

void
SurfaceFilterAttributes::SetMin(double min_)
{
    min = min_;
    Select(ID_min, (void *)&min);
}

void
SurfaceFilterAttributes::SetMax(double max_)
{
    max = max_;
    Select(ID_max, (void *)&max);
}

void
SurfaceFilterAttributes::SetZeroFlag(bool zeroFlag_)
{
    zeroFlag = zeroFlag_;
    Select(ID_zeroFlag, (void *)&zeroFlag);
}

void
SurfaceFilterAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

void
SurfaceFilterAttributes::SetUseXYLimits(SurfaceFilterAttributes::ScalingMode useXYLimits_)
{
    useXYLimits = useXYLimits_;
    Select(ID_useXYLimits, (void *)&useXYLimits);
}

void
SurfaceFilterAttributes::SetGenerateNodalOutput(bool generateNodalOutput_)
{
    generateNodalOutput = generateNodalOutput_;
    Select(ID_generateNodalOutput, (void *)&generateNodalOutput);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SurfaceFilterAttributes::LimitsMode
SurfaceFilterAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

bool
SurfaceFilterAttributes::GetMinFlag() const
{
    return minFlag;
}

bool
SurfaceFilterAttributes::GetMaxFlag() const
{
    return maxFlag;
}

SurfaceFilterAttributes::Scaling
SurfaceFilterAttributes::GetScaling() const
{
    return Scaling(scaling);
}

double
SurfaceFilterAttributes::GetSkewFactor() const
{
    return skewFactor;
}

double
SurfaceFilterAttributes::GetMin() const
{
    return min;
}

double
SurfaceFilterAttributes::GetMax() const
{
    return max;
}

bool
SurfaceFilterAttributes::GetZeroFlag() const
{
    return zeroFlag;
}

const std::string &
SurfaceFilterAttributes::GetVariable() const
{
    return variable;
}

std::string &
SurfaceFilterAttributes::GetVariable()
{
    return variable;
}

SurfaceFilterAttributes::ScalingMode
SurfaceFilterAttributes::GetUseXYLimits() const
{
    return ScalingMode(useXYLimits);
}

bool
SurfaceFilterAttributes::GetGenerateNodalOutput() const
{
    return generateNodalOutput;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceFilterAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceFilterAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SurfaceFilterAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_limitsMode:          return "limitsMode";
    case ID_minFlag:             return "minFlag";
    case ID_maxFlag:             return "maxFlag";
    case ID_scaling:             return "scaling";
    case ID_skewFactor:          return "skewFactor";
    case ID_min:                 return "min";
    case ID_max:                 return "max";
    case ID_zeroFlag:            return "zeroFlag";
    case ID_variable:            return "variable";
    case ID_useXYLimits:         return "useXYLimits";
    case ID_generateNodalOutput: return "generateNodalOutput";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
SurfaceFilterAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_limitsMode:          return FieldType_enum;
    case ID_minFlag:             return FieldType_bool;
    case ID_maxFlag:             return FieldType_bool;
    case ID_scaling:             return FieldType_enum;
    case ID_skewFactor:          return FieldType_double;
    case ID_min:                 return FieldType_double;
    case ID_max:                 return FieldType_double;
    case ID_zeroFlag:            return FieldType_bool;
    case ID_variable:            return FieldType_variablename;
    case ID_useXYLimits:         return FieldType_enum;
    case ID_generateNodalOutput: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SurfaceFilterAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_limitsMode:          return "enum";
    case ID_minFlag:             return "bool";
    case ID_maxFlag:             return "bool";
    case ID_scaling:             return "enum";
    case ID_skewFactor:          return "double";
    case ID_min:                 return "double";
    case ID_max:                 return "double";
    case ID_zeroFlag:            return "bool";
    case ID_variable:            return "variablename";
    case ID_useXYLimits:         return "enum";
    case ID_generateNodalOutput: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceFilterAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfaceFilterAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SurfaceFilterAttributes &obj = *((const SurfaceFilterAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_limitsMode:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case ID_minFlag:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case ID_maxFlag:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case ID_scaling:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case ID_skewFactor:
        {  // new scope
        retval = (skewFactor == obj.skewFactor);
        }
        break;
    case ID_min:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case ID_max:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case ID_zeroFlag:
        {  // new scope
        retval = (zeroFlag == obj.zeroFlag);
        }
        break;
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    case ID_useXYLimits:
        {  // new scope
        retval = (useXYLimits == obj.useXYLimits);
        }
        break;
    case ID_generateNodalOutput:
        {  // new scope
        retval = (generateNodalOutput == obj.generateNodalOutput);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

