// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SimulationUIValues.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose:
//   Init utility for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SimulationUIValues::Init()
{
    ivalue = 0;
    enabled = true;

    SimulationUIValues::SelectAll();
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose:
//   Copy utility for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SimulationUIValues::Copy(const SimulationUIValues &obj)
{
    host = obj.host;
    sim = obj.sim;
    name = obj.name;
    ivalue = obj.ivalue;
    svalue = obj.svalue;
    enabled = obj.enabled;

    SimulationUIValues::SelectAll();
}

// Type map format string
const char *SimulationUIValues::TypeMapFormatString = SIMULATIONUIVALUES_TMFS;
const AttributeGroup::private_tmfs_t SimulationUIValues::TmfsStruct = {SIMULATIONUIVALUES_TMFS};


// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose:
//   Default constructor for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SimulationUIValues::SimulationUIValues() :
    AttributeSubject(SimulationUIValues::TypeMapFormatString)
{
    SimulationUIValues::Init();
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose:
//   Constructor for the derived classes of SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SimulationUIValues::SimulationUIValues(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SimulationUIValues::Init();
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose:
//   Copy constructor for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SimulationUIValues::SimulationUIValues(const SimulationUIValues &obj) :
    AttributeSubject(SimulationUIValues::TypeMapFormatString)
{
    SimulationUIValues::Copy(obj);
}

// ****************************************************************************
// Method: SimulationUIValues::SimulationUIValues
//
// Purpose:
//   Copy constructor for derived classes of the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SimulationUIValues::SimulationUIValues(const SimulationUIValues &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SimulationUIValues::Copy(obj);
}

// ****************************************************************************
// Method: SimulationUIValues::~SimulationUIValues
//
// Purpose:
//   Destructor for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SimulationUIValues::~SimulationUIValues()
{
    // nothing here
}

// ****************************************************************************
// Method: SimulationUIValues::operator =
//
// Purpose:
//   Assignment operator for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SimulationUIValues&
SimulationUIValues::operator = (const SimulationUIValues &obj)
{
    if (this == &obj) return *this;

    SimulationUIValues::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SimulationUIValues::operator ==
//
// Purpose:
//   Comparison operator == for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SimulationUIValues::operator == (const SimulationUIValues &obj) const
{
    // Create the return value
    return ((host == obj.host) &&
            (sim == obj.sim) &&
            (name == obj.name) &&
            (ivalue == obj.ivalue) &&
            (svalue == obj.svalue) &&
            (enabled == obj.enabled));
}

// ****************************************************************************
// Method: SimulationUIValues::operator !=
//
// Purpose:
//   Comparison operator != for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SimulationUIValues::operator != (const SimulationUIValues &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SimulationUIValues::TypeName
//
// Purpose:
//   Type name method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
SimulationUIValues::TypeName() const
{
    return "SimulationUIValues";
}

// ****************************************************************************
// Method: SimulationUIValues::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SimulationUIValues::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SimulationUIValues *tmp = (const SimulationUIValues *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SimulationUIValues::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SimulationUIValues::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SimulationUIValues(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: SimulationUIValues::NewInstance
//
// Purpose:
//   NewInstance method for the SimulationUIValues class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SimulationUIValues::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SimulationUIValues(*this);
    else
        retval = new SimulationUIValues;

    return retval;
}

// ****************************************************************************
// Method: SimulationUIValues::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SimulationUIValues::SelectAll()
{
    Select(ID_host,    (void *)&host);
    Select(ID_sim,     (void *)&sim);
    Select(ID_name,    (void *)&name);
    Select(ID_ivalue,  (void *)&ivalue);
    Select(ID_svalue,  (void *)&svalue);
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationUIValues::SetHost(const std::string &host_)
{
    host = host_;
    Select(ID_host, (void *)&host);
}

void
SimulationUIValues::SetSim(const std::string &sim_)
{
    sim = sim_;
    Select(ID_sim, (void *)&sim);
}

void
SimulationUIValues::SetName(const std::string &name_)
{
    name = name_;
    Select(ID_name, (void *)&name);
}

void
SimulationUIValues::SetIvalue(int ivalue_)
{
    ivalue = ivalue_;
    Select(ID_ivalue, (void *)&ivalue);
}

void
SimulationUIValues::SetSvalue(const std::string &svalue_)
{
    svalue = svalue_;
    Select(ID_svalue, (void *)&svalue);
}

void
SimulationUIValues::SetEnabled(bool enabled_)
{
    enabled = enabled_;
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SimulationUIValues::GetHost() const
{
    return host;
}

std::string &
SimulationUIValues::GetHost()
{
    return host;
}

const std::string &
SimulationUIValues::GetSim() const
{
    return sim;
}

std::string &
SimulationUIValues::GetSim()
{
    return sim;
}

const std::string &
SimulationUIValues::GetName() const
{
    return name;
}

std::string &
SimulationUIValues::GetName()
{
    return name;
}

int
SimulationUIValues::GetIvalue() const
{
    return ivalue;
}

const std::string &
SimulationUIValues::GetSvalue() const
{
    return svalue;
}

std::string &
SimulationUIValues::GetSvalue()
{
    return svalue;
}

bool
SimulationUIValues::GetEnabled() const
{
    return enabled;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationUIValues::SelectHost()
{
    Select(ID_host, (void *)&host);
}

void
SimulationUIValues::SelectSim()
{
    Select(ID_sim, (void *)&sim);
}

void
SimulationUIValues::SelectName()
{
    Select(ID_name, (void *)&name);
}

void
SimulationUIValues::SelectSvalue()
{
    Select(ID_svalue, (void *)&svalue);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SimulationUIValues::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SimulationUIValues::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_host:    return "host";
    case ID_sim:     return "sim";
    case ID_name:    return "name";
    case ID_ivalue:  return "ivalue";
    case ID_svalue:  return "svalue";
    case ID_enabled: return "enabled";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SimulationUIValues::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
SimulationUIValues::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_host:    return FieldType_string;
    case ID_sim:     return FieldType_string;
    case ID_name:    return FieldType_string;
    case ID_ivalue:  return FieldType_int;
    case ID_svalue:  return FieldType_string;
    case ID_enabled: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SimulationUIValues::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SimulationUIValues::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_host:    return "string";
    case ID_sim:     return "string";
    case ID_name:    return "string";
    case ID_ivalue:  return "int";
    case ID_svalue:  return "string";
    case ID_enabled: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SimulationUIValues::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SimulationUIValues::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SimulationUIValues &obj = *((const SimulationUIValues*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_host:
        {  // new scope
        retval = (host == obj.host);
        }
        break;
    case ID_sim:
        {  // new scope
        retval = (sim == obj.sim);
        }
        break;
    case ID_name:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case ID_ivalue:
        {  // new scope
        retval = (ivalue == obj.ivalue);
        }
        break;
    case ID_svalue:
        {  // new scope
        retval = (svalue == obj.svalue);
        }
        break;
    case ID_enabled:
        {  // new scope
        retval = (enabled == obj.enabled);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

