// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SIMULATIONCOMMAND_H
#define SIMULATIONCOMMAND_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SimulationCommand
//
// Purpose:
//    Commands to control simulations
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SimulationCommand : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SimulationCommand();
    SimulationCommand(const SimulationCommand &obj);
protected:
    // These constructors are for objects derived from this class
    SimulationCommand(private_tmfs_t tmfs);
    SimulationCommand(const SimulationCommand &obj, private_tmfs_t tmfs);
public:
    virtual ~SimulationCommand();

    virtual SimulationCommand& operator = (const SimulationCommand &obj);
    virtual bool operator == (const SimulationCommand &obj) const;
    virtual bool operator != (const SimulationCommand &obj) const;
private:
    void Init();
    void Copy(const SimulationCommand &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCommand();

    // Property setting methods
    void SetCommand(const std::string &command_);

    // Property getting methods
    const std::string &GetCommand() const;
          std::string &GetCommand();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_command = 0,
        ID__LAST
    };

private:
    std::string command;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SIMULATIONCOMMAND_TMFS "s"

#endif
