// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SELECTIONVARIABLESUMMARY_H
#define SELECTIONVARIABLESUMMARY_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SelectionVariableSummary
//
// Purpose:
//    Contains a summary of a variable used in a selection
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SelectionVariableSummary : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SelectionVariableSummary();
    SelectionVariableSummary(const SelectionVariableSummary &obj);
protected:
    // These constructors are for objects derived from this class
    SelectionVariableSummary(private_tmfs_t tmfs);
    SelectionVariableSummary(const SelectionVariableSummary &obj, private_tmfs_t tmfs);
public:
    virtual ~SelectionVariableSummary();

    virtual SelectionVariableSummary& operator = (const SelectionVariableSummary &obj);
    virtual bool operator == (const SelectionVariableSummary &obj) const;
    virtual bool operator != (const SelectionVariableSummary &obj) const;
private:
    void Init();
    void Copy(const SelectionVariableSummary &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectName();
    void SelectHistogram();

    // Property setting methods
    void SetName(const std::string &name_);
    void SetMinimum(double minimum_);
    void SetMaximum(double maximum_);
    void SetHistogram(const double *histogram_);

    // Property getting methods
    const std::string &GetName() const;
          std::string &GetName();
    double            GetMinimum() const;
    double            GetMaximum() const;
    const double      *GetHistogram() const;
          double      *GetHistogram();

    // User-defined methods
    void SetHistogram(int index, double value);
    void NormalizedHistogram(float hist[256]) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_name = 0,
        ID_minimum,
        ID_maximum,
        ID_histogram,
        ID__LAST
    };

private:
    std::string name;
    double      minimum;
    double      maximum;
    double      histogram[256];

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SELECTIONVARIABLESUMMARY_TMFS "sddD"

#endif
