// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SelectionVariableSummary.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SelectionVariableSummary::SelectionVariableSummary
//
// Purpose:
//   Init utility for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SelectionVariableSummary::Init()
{
    minimum = 0;
    maximum = 0;
for(int i = 0; i < 256; ++i)
    histogram[i] = 0.;

    SelectionVariableSummary::SelectAll();
}

// ****************************************************************************
// Method: SelectionVariableSummary::SelectionVariableSummary
//
// Purpose:
//   Copy utility for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SelectionVariableSummary::Copy(const SelectionVariableSummary &obj)
{

    name = obj.name;
    minimum = obj.minimum;
    maximum = obj.maximum;
    for(int i = 0; i < 256; ++i)
        histogram[i] = obj.histogram[i];


    SelectionVariableSummary::SelectAll();
}

// Type map format string
const char *SelectionVariableSummary::TypeMapFormatString = SELECTIONVARIABLESUMMARY_TMFS;
const AttributeGroup::private_tmfs_t SelectionVariableSummary::TmfsStruct = {SELECTIONVARIABLESUMMARY_TMFS};


// ****************************************************************************
// Method: SelectionVariableSummary::SelectionVariableSummary
//
// Purpose:
//   Default constructor for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SelectionVariableSummary::SelectionVariableSummary() :
    AttributeSubject(SelectionVariableSummary::TypeMapFormatString)
{
    SelectionVariableSummary::Init();
}

// ****************************************************************************
// Method: SelectionVariableSummary::SelectionVariableSummary
//
// Purpose:
//   Constructor for the derived classes of SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SelectionVariableSummary::SelectionVariableSummary(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SelectionVariableSummary::Init();
}

// ****************************************************************************
// Method: SelectionVariableSummary::SelectionVariableSummary
//
// Purpose:
//   Copy constructor for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SelectionVariableSummary::SelectionVariableSummary(const SelectionVariableSummary &obj) :
    AttributeSubject(SelectionVariableSummary::TypeMapFormatString)
{
    SelectionVariableSummary::Copy(obj);
}

// ****************************************************************************
// Method: SelectionVariableSummary::SelectionVariableSummary
//
// Purpose:
//   Copy constructor for derived classes of the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SelectionVariableSummary::SelectionVariableSummary(const SelectionVariableSummary &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SelectionVariableSummary::Copy(obj);
}

// ****************************************************************************
// Method: SelectionVariableSummary::~SelectionVariableSummary
//
// Purpose:
//   Destructor for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SelectionVariableSummary::~SelectionVariableSummary()
{
    // nothing here
}

// ****************************************************************************
// Method: SelectionVariableSummary::operator =
//
// Purpose:
//   Assignment operator for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SelectionVariableSummary&
SelectionVariableSummary::operator = (const SelectionVariableSummary &obj)
{
    if (this == &obj) return *this;

    SelectionVariableSummary::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SelectionVariableSummary::operator ==
//
// Purpose:
//   Comparison operator == for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SelectionVariableSummary::operator == (const SelectionVariableSummary &obj) const
{
    // Compare the histogram arrays.
    bool histogram_equal = true;
    for(int i = 0; i < 256 && histogram_equal; ++i)
        histogram_equal = (histogram[i] == obj.histogram[i]);

    // Create the return value
    return ((name == obj.name) &&
            (minimum == obj.minimum) &&
            (maximum == obj.maximum) &&
            histogram_equal);
}

// ****************************************************************************
// Method: SelectionVariableSummary::operator !=
//
// Purpose:
//   Comparison operator != for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SelectionVariableSummary::operator != (const SelectionVariableSummary &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SelectionVariableSummary::TypeName
//
// Purpose:
//   Type name method for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
SelectionVariableSummary::TypeName() const
{
    return "SelectionVariableSummary";
}

// ****************************************************************************
// Method: SelectionVariableSummary::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SelectionVariableSummary::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SelectionVariableSummary *tmp = (const SelectionVariableSummary *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SelectionVariableSummary::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SelectionVariableSummary::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SelectionVariableSummary(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: SelectionVariableSummary::NewInstance
//
// Purpose:
//   NewInstance method for the SelectionVariableSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SelectionVariableSummary::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SelectionVariableSummary(*this);
    else
        retval = new SelectionVariableSummary;

    return retval;
}

// ****************************************************************************
// Method: SelectionVariableSummary::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SelectionVariableSummary::SelectAll()
{
    Select(ID_name,      (void *)&name);
    Select(ID_minimum,   (void *)&minimum);
    Select(ID_maximum,   (void *)&maximum);
    Select(ID_histogram, (void *)histogram, 256);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SelectionVariableSummary::SetName(const std::string &name_)
{
    name = name_;
    Select(ID_name, (void *)&name);
}

void
SelectionVariableSummary::SetMinimum(double minimum_)
{
    minimum = minimum_;
    Select(ID_minimum, (void *)&minimum);
}

void
SelectionVariableSummary::SetMaximum(double maximum_)
{
    maximum = maximum_;
    Select(ID_maximum, (void *)&maximum);
}

void
SelectionVariableSummary::SetHistogram(const double *histogram_)
{
    for(int i = 0; i < 256; ++i)
        histogram[i] = histogram_[i];
    Select(ID_histogram, (void *)histogram, 256);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SelectionVariableSummary::GetName() const
{
    return name;
}

std::string &
SelectionVariableSummary::GetName()
{
    return name;
}

double
SelectionVariableSummary::GetMinimum() const
{
    return minimum;
}

double
SelectionVariableSummary::GetMaximum() const
{
    return maximum;
}

const double *
SelectionVariableSummary::GetHistogram() const
{
    return histogram;
}

double *
SelectionVariableSummary::GetHistogram()
{
    return histogram;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SelectionVariableSummary::SelectName()
{
    Select(ID_name, (void *)&name);
}

void
SelectionVariableSummary::SelectHistogram()
{
    Select(ID_histogram, (void *)histogram, 256);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
SelectionVariableSummary::SetHistogram(int index, double value)
{
    if(index >= 0 && index < 256)
        histogram[index] = value;
}

void
SelectionVariableSummary::NormalizedHistogram(float hist[256]) const
{
    // find the min/max
    double minval = histogram[0];
    double maxval = histogram[0];
    for(int i = 1; i < 256; ++i)
    {
        if(histogram[i] < minval)
            minval = histogram[i];
        if(histogram[i] > maxval)
            maxval = histogram[i];
    }

    if(minval == maxval)
    {
        for(int i = 0; i < 256; ++i)
            hist[i] = (minval != 0.) ? 1.f : 0.f;
    }
    else
    {
        for(int i = 0; i < 256; ++i)
            hist[i] = (float)(histogram[i] / maxval);
    }
}

