// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SELECTIONSUMMARY_H
#define SELECTIONSUMMARY_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

class SelectionVariableSummary;

// ****************************************************************************
// Class: SelectionSummary
//
// Purpose:
//    Contains attributes for a selection
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SelectionSummary : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SelectionSummary();
    SelectionSummary(const SelectionSummary &obj);
protected:
    // These constructors are for objects derived from this class
    SelectionSummary(private_tmfs_t tmfs);
    SelectionSummary(const SelectionSummary &obj, private_tmfs_t tmfs);
public:
    virtual ~SelectionSummary();

    virtual SelectionSummary& operator = (const SelectionSummary &obj);
    virtual bool operator == (const SelectionSummary &obj) const;
    virtual bool operator != (const SelectionSummary &obj) const;
private:
    void Init();
    void Copy(const SelectionSummary &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectName();
    void SelectVariables();
    void SelectHistogramValues();

    // Property setting methods
    void SetName(const std::string &name_);
    void SetCellCount(int cellCount_);
    void SetTotalCellCount(int totalCellCount_);
    void SetHistogramValues(const doubleVector &histogramValues_);
    void SetHistogramMinBin(double histogramMinBin_);
    void SetHistogramMaxBin(double histogramMaxBin_);

    // Property getting methods
    const std::string  &GetName() const;
          std::string  &GetName();
    const AttributeGroupVector &GetVariables() const;
          AttributeGroupVector &GetVariables();
    int                GetCellCount() const;
    int                GetTotalCellCount() const;
    const doubleVector &GetHistogramValues() const;
          doubleVector &GetHistogramValues();
    double             GetHistogramMinBin() const;
    double             GetHistogramMaxBin() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddVariables(const SelectionVariableSummary &);
    void ClearVariables();
    void RemoveVariables(int i);
    int  GetNumVariables() const;
    SelectionVariableSummary &GetVariables(int i);
    const SelectionVariableSummary &GetVariables(int i) const;

    SelectionVariableSummary &operator [] (int i);
    const SelectionVariableSummary &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_name = 0,
        ID_variables,
        ID_cellCount,
        ID_totalCellCount,
        ID_histogramValues,
        ID_histogramMinBin,
        ID_histogramMaxBin,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    std::string          name;
    AttributeGroupVector variables;
    int                  cellCount;
    int                  totalCellCount;
    doubleVector         histogramValues;
    double               histogramMinBin;
    double               histogramMaxBin;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SELECTIONSUMMARY_TMFS "sa*iid*dd"

#endif
