// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QUERYLIST_H
#define QUERYLIST_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <StringHelpers.h>

// ****************************************************************************
// Class: QueryList
//
// Purpose:
//    List of supported queries
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API QueryList : public AttributeSubject
{
public:
    enum QueryType
    {
        DatabaseQuery,
        PointQuery,
        LineQuery
    };
    enum WindowType
    {
        Basic,
        DomainNode,
        DomainNodeVars,
        DomainZone,
        DomainZoneVars,
        ActualData,
        ActualDataVars,
        LineDistribution,
        HohlraumFlux,
        ConnCompSummary,
        ShapeletsDecomp,
        XRayImage,
        LineSamplerInfo,
        IntegralCurveInfo,
        Pick,
        Lineout,
        Compactness,
        CompactnessVar
    };
    enum Groups
    {
        CurveRelated,
        MeshRelated,
        TimeRelated,
        VariableRelated,
        ShapeRelated,
        ConnectedComponentsRelated,
        Miscellaneous,
        NumGroups
    };
    enum QueryMode
    {
        QueryOnly,
        QueryAndTime,
        TimeOnly
    };

    // These constructors are for objects of this class
    QueryList();
    QueryList(const QueryList &obj);
protected:
    // These constructors are for objects derived from this class
    QueryList(private_tmfs_t tmfs);
    QueryList(const QueryList &obj, private_tmfs_t tmfs);
public:
    virtual ~QueryList();

    virtual QueryList& operator = (const QueryList &obj);
    virtual bool operator == (const QueryList &obj) const;
    virtual bool operator != (const QueryList &obj) const;
private:
    void Init();
    void Copy(const QueryList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectNames();
    void SelectTypes();
    void SelectGroups();
    void SelectNumInputs();
    void SelectAllowedVarTypes();
    void SelectWinType();
    void SelectQueryMode();
    void SelectNumVars();
    void SelectCanBePublic();
    void SelectRequiresVarSelection();

    // Property setting methods
    void SetNames(const stringVector &names_);
    void SetTypes(const intVector &types_);
    void SetGroups(const intVector &groups_);
    void SetNumInputs(const intVector &numInputs_);
    void SetAllowedVarTypes(const intVector &allowedVarTypes_);
    void SetWinType(const intVector &winType_);
    void SetQueryMode(const intVector &queryMode_);
    void SetNumVars(const intVector &numVars_);
    void SetCanBePublic(const intVector &canBePublic_);
    void SetRequiresVarSelection(const intVector &requiresVarSelection_);

    // Property getting methods
    const stringVector &GetNames() const;
          stringVector &GetNames();
    const intVector    &GetTypes() const;
          intVector    &GetTypes();
    const intVector    &GetGroups() const;
          intVector    &GetGroups();
    const intVector    &GetNumInputs() const;
          intVector    &GetNumInputs();
    const intVector    &GetAllowedVarTypes() const;
          intVector    &GetAllowedVarTypes();
    const intVector    &GetWinType() const;
          intVector    &GetWinType();
    const intVector    &GetQueryMode() const;
          intVector    &GetQueryMode();
    const intVector    &GetNumVars() const;
          intVector    &GetNumVars();
    const intVector    &GetCanBePublic() const;
          intVector    &GetCanBePublic();
    const intVector    &GetRequiresVarSelection() const;
          intVector    &GetRequiresVarSelection();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string QueryType_ToString(QueryType);
    static bool QueryType_FromString(const std::string &, QueryType &);
protected:
    static std::string QueryType_ToString(int);
public:
    static std::string WindowType_ToString(WindowType);
    static bool WindowType_FromString(const std::string &, WindowType &);
protected:
    static std::string WindowType_ToString(int);
public:
    static std::string Groups_ToString(Groups);
    static bool Groups_FromString(const std::string &, Groups &);
protected:
    static std::string Groups_ToString(int);
public:
    static std::string QueryMode_ToString(QueryMode);
    static bool QueryMode_FromString(const std::string &, QueryMode &);
protected:
    static std::string QueryMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void AddQuery(const std::string &name, QueryType t, Groups g, WindowType w, int num_input, int allowedVars, QueryMode qMode, int numVars = 1, int reqVars = 0);
    bool QueryExists(const std::string &name, QueryType t);
    int NumberOfInputsForQuery(const std::string &name);
    int AllowedVarsForQuery(const std::string &name);
    bool TimeQueryAvailable(const std::string &name) ;
    int GetWindowType(const std::string &name) ;
    int NumberOfVarsForQuery(const std::string &name);
    bool RegularQueryAvailable(const std::string &name) ;
    int GetQueryType(const std::string &name) ;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_names = 0,
        ID_types,
        ID_groups,
        ID_numInputs,
        ID_allowedVarTypes,
        ID_winType,
        ID_queryMode,
        ID_numVars,
        ID_canBePublic,
        ID_requiresVarSelection,
        ID__LAST
    };

private:
    stringVector names;
    intVector    types;
    intVector    groups;
    intVector    numInputs;
    intVector    allowedVarTypes;
    intVector    winType;
    intVector    queryMode;
    intVector    numVars;
    intVector    canBePublic;
    intVector    requiresVarSelection;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define QUERYLIST_TMFS "s*i*i*i*i*i*i*i*i*i*"

#endif
