// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PROCESSATTRIBUTES_H
#define PROCESSATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ProcessAttributes
//
// Purpose:
//    attributes to describe a running process
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ProcessAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ProcessAttributes();
    ProcessAttributes(const ProcessAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ProcessAttributes(private_tmfs_t tmfs);
    ProcessAttributes(const ProcessAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ProcessAttributes();

    virtual ProcessAttributes& operator = (const ProcessAttributes &obj);
    virtual bool operator == (const ProcessAttributes &obj) const;
    virtual bool operator != (const ProcessAttributes &obj) const;
private:
    void Init();
    void Copy(const ProcessAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPids();
    void SelectPpids();
    void SelectHosts();
    void SelectMemory();
    void SelectTimes();

    // Property setting methods
    void SetPids(const intVector &pids_);
    void SetPpids(const intVector &ppids_);
    void SetHosts(const stringVector &hosts_);
    void SetIsParallel(bool isParallel_);
    void SetMemory(const intVector &memory_);
    void SetTimes(const doubleVector &times_);

    // Property getting methods
    const intVector    &GetPids() const;
          intVector    &GetPids();
    const intVector    &GetPpids() const;
          intVector    &GetPpids();
    const stringVector &GetHosts() const;
          stringVector &GetHosts();
    bool               GetIsParallel() const;
    const intVector    &GetMemory() const;
          intVector    &GetMemory();
    const doubleVector &GetTimes() const;
          doubleVector &GetTimes();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_pids = 0,
        ID_ppids,
        ID_hosts,
        ID_isParallel,
        ID_memory,
        ID_times,
        ID__LAST
    };

private:
    intVector    pids;
    intVector    ppids;
    stringVector hosts;
    bool         isParallel;
    intVector    memory;
    doubleVector times;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PROCESSATTRIBUTES_TMFS "i*i*s*bi*d*"

#endif
