// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PLOTQUERYINFO_H
#define PLOTQUERYINFO_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: PlotQueryInfo
//
// Purpose:
//    This class is a .
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API PlotQueryInfo : public AttributeSubject
{
public:
    enum ChangeType
    {
        None,
        Database,
        VarName,
        AddOp,
        OpAtts,
        PlotAtts,
        MoveOperator,
        RemoveOperator,
        RemoveAll,
        RemoveLast,
        CacheIndex
    };

    // These constructors are for objects of this class
    PlotQueryInfo();
    PlotQueryInfo(const PlotQueryInfo &obj);
protected:
    // These constructors are for objects derived from this class
    PlotQueryInfo(private_tmfs_t tmfs);
    PlotQueryInfo(const PlotQueryInfo &obj, private_tmfs_t tmfs);
public:
    virtual ~PlotQueryInfo();

    virtual PlotQueryInfo& operator = (const PlotQueryInfo &obj);
    virtual bool operator == (const PlotQueryInfo &obj) const;
    virtual bool operator != (const PlotQueryInfo &obj) const;
private:
    void Init();
    void Copy(const PlotQueryInfo &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetChangeType(ChangeType changeType_);
    void SetOldFrameIndex(int oldFrameIndex_);
    void SetNewFrameIndex(int newFrameIndex_);

    // Property getting methods
    ChangeType GetChangeType() const;
    int GetOldFrameIndex() const;
    int GetNewFrameIndex() const;

    // Enum conversion functions
    static std::string ChangeType_ToString(ChangeType);
    static bool ChangeType_FromString(const std::string &, ChangeType &);
protected:
    static std::string ChangeType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_changeType = 0,
        ID_oldFrameIndex,
        ID_newFrameIndex,
        ID__LAST
    };

private:
    int changeType;
    int oldFrameIndex;
    int newFrameIndex;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PLOTQUERYINFO_TMFS "iii"

#endif
