// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PLOTLIST_H
#define PLOTLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>

class Plot;

// ****************************************************************************
// Class: PlotList
//
// Purpose:
//    This class contains a list of plots.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API PlotList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    PlotList();
    PlotList(const PlotList &obj);
protected:
    // These constructors are for objects derived from this class
    PlotList(private_tmfs_t tmfs);
    PlotList(const PlotList &obj, private_tmfs_t tmfs);
public:
    virtual ~PlotList();

    virtual PlotList& operator = (const PlotList &obj);
    virtual bool operator == (const PlotList &obj) const;
    virtual bool operator != (const PlotList &obj) const;
private:
    void Init();
    void Copy(const PlotList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPlots();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetPlots() const;
          AttributeGroupVector &GetPlots();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddPlots(const Plot &);
    void ClearPlots();
    void RemovePlots(int i);
    int  GetNumPlots() const;
    Plot &GetPlots(int i);
    const Plot &GetPlots(int i) const;

    Plot &operator [] (int i);
    const Plot &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void AddPlot(const Plot &p, int id);
    int FirstSelectedIndex() const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_plots = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector plots;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PLOTLIST_TMFS "a*"

#endif
