// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef KEYFRAMEATTRIBUTES_H
#define KEYFRAMEATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: KeyframeAttributes
//
// Purpose:
//    This class contains the attributes used for keyframing.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API KeyframeAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    KeyframeAttributes();
    KeyframeAttributes(const KeyframeAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    KeyframeAttributes(private_tmfs_t tmfs);
    KeyframeAttributes(const KeyframeAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~KeyframeAttributes();

    virtual KeyframeAttributes& operator = (const KeyframeAttributes &obj);
    virtual bool operator == (const KeyframeAttributes &obj) const;
    virtual bool operator != (const KeyframeAttributes &obj) const;
private:
    void Init();
    void Copy(const KeyframeAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetEnabled(bool enabled_);
    void SetNFrames(int nFrames_);
    void SetNFramesWasUserSet(bool nFramesWasUserSet_);

    // Property getting methods
    bool GetEnabled() const;
    int  GetNFrames() const;
    bool GetNFramesWasUserSet() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_enabled = 0,
        ID_nFrames,
        ID_nFramesWasUserSet,
        ID__LAST
    };

private:
    bool enabled;
    int  nFrames;
    bool nFramesWasUserSet;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define KEYFRAMEATTRIBUTES_TMFS "bib"

#endif
