// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef INTERNALRESAMPLEATTRIBUTES_H
#define INTERNALRESAMPLEATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: InternalResampleAttributes
//
// Purpose:
//    This class contains attributes to specify a resampling.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API InternalResampleAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    InternalResampleAttributes();
    InternalResampleAttributes(const InternalResampleAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    InternalResampleAttributes(private_tmfs_t tmfs);
    InternalResampleAttributes(const InternalResampleAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~InternalResampleAttributes();

    virtual InternalResampleAttributes& operator = (const InternalResampleAttributes &obj);
    virtual bool operator == (const InternalResampleAttributes &obj) const;
    virtual bool operator != (const InternalResampleAttributes &obj) const;
private:
    void Init();
    void Copy(const InternalResampleAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectArbitratorVarName();

    // Property setting methods
    void SetUseTargetVal(bool useTargetVal_);
    void SetTargetVal(int targetVal_);
    void SetWidth(int width_);
    void SetHeight(int height_);
    void SetDepth(int depth_);
    void SetPrefersPowersOfTwo(bool prefersPowersOfTwo_);
    void SetDefaultVal(float defaultVal_);
    void SetUseBounds(bool useBounds_);
    void SetMinX(double minX_);
    void SetMinY(double minY_);
    void SetMinZ(double minZ_);
    void SetMaxX(double maxX_);
    void SetMaxY(double maxY_);
    void SetMaxZ(double maxZ_);
    void SetUseArbitrator(bool useArbitrator_);
    void SetArbitratorLessThan(bool arbitratorLessThan_);
    void SetArbitratorVarName(const std::string &arbitratorVarName_);
    void SetDistributedResample(bool distributedResample_);

    // Property getting methods
    bool              GetUseTargetVal() const;
    int               GetTargetVal() const;
    int               GetWidth() const;
    int               GetHeight() const;
    int               GetDepth() const;
    bool              GetPrefersPowersOfTwo() const;
    float             GetDefaultVal() const;
    bool              GetUseBounds() const;
    double            GetMinX() const;
    double            GetMinY() const;
    double            GetMinZ() const;
    double            GetMaxX() const;
    double            GetMaxY() const;
    double            GetMaxZ() const;
    bool              GetUseArbitrator() const;
    bool              GetArbitratorLessThan() const;
    const std::string &GetArbitratorVarName() const;
          std::string &GetArbitratorVarName();
    bool              GetDistributedResample() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_useTargetVal = 0,
        ID_targetVal,
        ID_width,
        ID_height,
        ID_depth,
        ID_prefersPowersOfTwo,
        ID_defaultVal,
        ID_useBounds,
        ID_minX,
        ID_minY,
        ID_minZ,
        ID_maxX,
        ID_maxY,
        ID_maxZ,
        ID_useArbitrator,
        ID_arbitratorLessThan,
        ID_arbitratorVarName,
        ID_distributedResample,
        ID__LAST
    };

private:
    bool        useTargetVal;
    int         targetVal;
    int         width;
    int         height;
    int         depth;
    bool        prefersPowersOfTwo;
    float       defaultVal;
    bool        useBounds;
    double      minX;
    double      minY;
    double      minZ;
    double      maxX;
    double      maxY;
    double      maxZ;
    bool        useArbitrator;
    bool        arbitratorLessThan;
    std::string arbitratorVarName;
    bool        distributedResample;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define INTERNALRESAMPLEATTRIBUTES_TMFS "biiiibfbddddddbbsb"

#endif
