// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef GLOBALLINEOUTATTRIBUTES_H
#define GLOBALLINEOUTATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: GlobalLineoutAttributes
//
// Purpose:
//    This file contains global attributes controlling Lineouts.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API GlobalLineoutAttributes : public AttributeSubject
{
public:
    enum CurveOptions
    {
        UpdateCurve,
        CreateCurve
    };
    enum ColorOptions
    {
        RepeatColor,
        CreateColor
    };

    // These constructors are for objects of this class
    GlobalLineoutAttributes();
    GlobalLineoutAttributes(const GlobalLineoutAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    GlobalLineoutAttributes(private_tmfs_t tmfs);
    GlobalLineoutAttributes(const GlobalLineoutAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~GlobalLineoutAttributes();

    virtual GlobalLineoutAttributes& operator = (const GlobalLineoutAttributes &obj);
    virtual bool operator == (const GlobalLineoutAttributes &obj) const;
    virtual bool operator != (const GlobalLineoutAttributes &obj) const;
private:
    void Init();
    void Copy(const GlobalLineoutAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetDynamic(bool Dynamic_);
    void SetCreateWindow(bool createWindow_);
    void SetWindowId(int windowId_);
    void SetSamplingOn(bool samplingOn_);
    void SetNumSamples(int numSamples_);
    void SetCreateReflineLabels(bool createReflineLabels_);
    void SetCurveOption(CurveOptions curveOption_);
    void SetColorOption(ColorOptions colorOption_);
    void SetFreezeInTime(bool freezeInTime_);

    // Property getting methods
    bool GetDynamic() const;
    bool GetCreateWindow() const;
    int  GetWindowId() const;
    bool GetSamplingOn() const;
    int  GetNumSamples() const;
    bool GetCreateReflineLabels() const;
    CurveOptions GetCurveOption() const;
    ColorOptions GetColorOption() const;
    bool GetFreezeInTime() const;

    // Enum conversion functions
    static std::string CurveOptions_ToString(CurveOptions);
    static bool CurveOptions_FromString(const std::string &, CurveOptions &);
protected:
    static std::string CurveOptions_ToString(int);
public:
    static std::string ColorOptions_ToString(ColorOptions);
    static bool ColorOptions_FromString(const std::string &, ColorOptions &);
protected:
    static std::string ColorOptions_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_Dynamic = 0,
        ID_createWindow,
        ID_windowId,
        ID_samplingOn,
        ID_numSamples,
        ID_createReflineLabels,
        ID_curveOption,
        ID_colorOption,
        ID_freezeInTime,
        ID__LAST
    };

private:
    bool Dynamic;
    bool createWindow;
    int  windowId;
    bool samplingOn;
    int  numSamples;
    bool createReflineLabels;
    int  curveOption;
    int  colorOption;
    bool freezeInTime;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define GLOBALLINEOUTATTRIBUTES_TMFS "bbibibiib"

#endif
