// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef GAUSSIANCONTROLPOINT_H
#define GAUSSIANCONTROLPOINT_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: GaussianControlPoint
//
// Purpose:
//    This class contains the information for a gaussian in the opacity bar.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API GaussianControlPoint : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    GaussianControlPoint();
    GaussianControlPoint(const GaussianControlPoint &obj);
protected:
    // These constructors are for objects derived from this class
    GaussianControlPoint(private_tmfs_t tmfs);
    GaussianControlPoint(const GaussianControlPoint &obj, private_tmfs_t tmfs);
public:
    virtual ~GaussianControlPoint();

    virtual GaussianControlPoint& operator = (const GaussianControlPoint &obj);
    virtual bool operator == (const GaussianControlPoint &obj) const;
    virtual bool operator != (const GaussianControlPoint &obj) const;
private:
    void Init();
    void Copy(const GaussianControlPoint &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetX(float x_);
    void SetHeight(float height_);
    void SetWidth(float width_);
    void SetXBias(float xBias_);
    void SetYBias(float yBias_);

    // Property getting methods
    float GetX() const;
    float GetHeight() const;
    float GetWidth() const;
    float GetXBias() const;
    float GetYBias() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_x = 0,
        ID_height,
        ID_width,
        ID_xBias,
        ID_yBias,
        ID__LAST
    };

private:
    float x;
    float height;
    float width;
    float xBias;
    float yBias;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define GAUSSIANCONTROLPOINT_TMFS "fffff"

#endif
