// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef FONTATTRIBUTES_H
#define FONTATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <ColorAttribute.h>

// ****************************************************************************
// Class: FontAttributes
//
// Purpose:
//    Describes font properties that we can set through VTK
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API FontAttributes : public AttributeSubject
{
public:
    enum FontName
    {
        Arial,
        Courier,
        Times
    };

    // These constructors are for objects of this class
    FontAttributes();
    FontAttributes(const FontAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    FontAttributes(private_tmfs_t tmfs);
    FontAttributes(const FontAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~FontAttributes();

    virtual FontAttributes& operator = (const FontAttributes &obj);
    virtual bool operator == (const FontAttributes &obj) const;
    virtual bool operator != (const FontAttributes &obj) const;
private:
    void Init();
    void Copy(const FontAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectColor();

    // Property setting methods
    void SetFont(FontName font_);
    void SetScale(double scale_);
    void SetUseForegroundColor(bool useForegroundColor_);
    void SetColor(const ColorAttribute &color_);
    void SetBold(bool bold_);
    void SetItalic(bool italic_);

    // Property getting methods
    FontName             GetFont() const;
    double               GetScale() const;
    bool                 GetUseForegroundColor() const;
    const ColorAttribute &GetColor() const;
          ColorAttribute &GetColor();
    bool                 GetBold() const;
    bool                 GetItalic() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string FontName_ToString(FontName);
    static bool FontName_FromString(const std::string &, FontName &);
protected:
    static std::string FontName_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_font = 0,
        ID_scale,
        ID_useForegroundColor,
        ID_color,
        ID_bold,
        ID_italic,
        ID__LAST
    };

private:
    int            font;
    double         scale;
    bool           useForegroundColor;
    ColorAttribute color;
    bool           bold;
    bool           italic;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define FONTATTRIBUTES_TMFS "idbabb"

#endif
