// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <FontAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for FontAttributes::FontName
//

static const char *FontName_strings[] = {
"Arial", "Courier", "Times"
};

std::string
FontAttributes::FontName_ToString(FontAttributes::FontName t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return FontName_strings[index];
}

std::string
FontAttributes::FontName_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return FontName_strings[index];
}

bool
FontAttributes::FontName_FromString(const std::string &s, FontAttributes::FontName &val)
{
    val = FontAttributes::Arial;
    for(int i = 0; i < 3; ++i)
    {
        if(s == FontName_strings[i])
        {
            val = (FontName)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: FontAttributes::FontAttributes
//
// Purpose:
//   Init utility for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void FontAttributes::Init()
{
    font = Arial;
    scale = 1;
    useForegroundColor = true;
    bold = false;
    italic = false;

    FontAttributes::SelectAll();
}

// ****************************************************************************
// Method: FontAttributes::FontAttributes
//
// Purpose:
//   Copy utility for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void FontAttributes::Copy(const FontAttributes &obj)
{
    font = obj.font;
    scale = obj.scale;
    useForegroundColor = obj.useForegroundColor;
    color = obj.color;
    bold = obj.bold;
    italic = obj.italic;

    FontAttributes::SelectAll();
}

// Type map format string
const char *FontAttributes::TypeMapFormatString = FONTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t FontAttributes::TmfsStruct = {FONTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: FontAttributes::FontAttributes
//
// Purpose:
//   Default constructor for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FontAttributes::FontAttributes() :
    AttributeSubject(FontAttributes::TypeMapFormatString),
    color(0, 0, 0)
{
    FontAttributes::Init();
}

// ****************************************************************************
// Method: FontAttributes::FontAttributes
//
// Purpose:
//   Constructor for the derived classes of FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FontAttributes::FontAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    color(0, 0, 0)
{
    FontAttributes::Init();
}

// ****************************************************************************
// Method: FontAttributes::FontAttributes
//
// Purpose:
//   Copy constructor for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FontAttributes::FontAttributes(const FontAttributes &obj) :
    AttributeSubject(FontAttributes::TypeMapFormatString)
{
    FontAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FontAttributes::FontAttributes
//
// Purpose:
//   Copy constructor for derived classes of the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FontAttributes::FontAttributes(const FontAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    FontAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FontAttributes::~FontAttributes
//
// Purpose:
//   Destructor for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FontAttributes::~FontAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: FontAttributes::operator =
//
// Purpose:
//   Assignment operator for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FontAttributes&
FontAttributes::operator = (const FontAttributes &obj)
{
    if (this == &obj) return *this;

    FontAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: FontAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FontAttributes::operator == (const FontAttributes &obj) const
{
    // Create the return value
    return ((font == obj.font) &&
            (scale == obj.scale) &&
            (useForegroundColor == obj.useForegroundColor) &&
            (color == obj.color) &&
            (bold == obj.bold) &&
            (italic == obj.italic));
}

// ****************************************************************************
// Method: FontAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FontAttributes::operator != (const FontAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: FontAttributes::TypeName
//
// Purpose:
//   Type name method for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
FontAttributes::TypeName() const
{
    return "FontAttributes";
}

// ****************************************************************************
// Method: FontAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FontAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const FontAttributes *tmp = (const FontAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: FontAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
FontAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new FontAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: FontAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the FontAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
FontAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new FontAttributes(*this);
    else
        retval = new FontAttributes;

    return retval;
}

// ****************************************************************************
// Method: FontAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FontAttributes::SelectAll()
{
    Select(ID_font,               (void *)&font);
    Select(ID_scale,              (void *)&scale);
    Select(ID_useForegroundColor, (void *)&useForegroundColor);
    Select(ID_color,              (void *)&color);
    Select(ID_bold,               (void *)&bold);
    Select(ID_italic,             (void *)&italic);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FontAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FontAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    FontAttributes defaultObject;
    bool addToParent = false;
    // Create a node for FontAttributes.
    DataNode *node = new DataNode("FontAttributes");

    if(completeSave || !FieldsEqual(ID_font, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("font", FontName_ToString(font)));
    }

    if(completeSave || !FieldsEqual(ID_scale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scale", scale));
    }

    if(completeSave || !FieldsEqual(ID_useForegroundColor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useForegroundColor", useForegroundColor));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;
    if(completeSave || !FieldsEqual(ID_bold, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("bold", bold));
    }

    if(completeSave || !FieldsEqual(ID_italic, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("italic", italic));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: FontAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FontAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("FontAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("font")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetFont(FontName(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            FontName value;
            if(FontName_FromString(node->AsString(), value))
                SetFont(value);
        }
    }
    if((node = searchNode->GetNode("scale")) != 0)
        SetScale(node->AsDouble());
    if((node = searchNode->GetNode("useForegroundColor")) != 0)
        SetUseForegroundColor(node->AsBool());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
    if((node = searchNode->GetNode("bold")) != 0)
        SetBold(node->AsBool());
    if((node = searchNode->GetNode("italic")) != 0)
        SetItalic(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
FontAttributes::SetFont(FontAttributes::FontName font_)
{
    font = font_;
    Select(ID_font, (void *)&font);
}

void
FontAttributes::SetScale(double scale_)
{
    scale = scale_;
    Select(ID_scale, (void *)&scale);
}

void
FontAttributes::SetUseForegroundColor(bool useForegroundColor_)
{
    useForegroundColor = useForegroundColor_;
    Select(ID_useForegroundColor, (void *)&useForegroundColor);
}

void
FontAttributes::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(ID_color, (void *)&color);
}

void
FontAttributes::SetBold(bool bold_)
{
    bold = bold_;
    Select(ID_bold, (void *)&bold);
}

void
FontAttributes::SetItalic(bool italic_)
{
    italic = italic_;
    Select(ID_italic, (void *)&italic);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

FontAttributes::FontName
FontAttributes::GetFont() const
{
    return FontName(font);
}

double
FontAttributes::GetScale() const
{
    return scale;
}

bool
FontAttributes::GetUseForegroundColor() const
{
    return useForegroundColor;
}

const ColorAttribute &
FontAttributes::GetColor() const
{
    return color;
}

ColorAttribute &
FontAttributes::GetColor()
{
    return color;
}

bool
FontAttributes::GetBold() const
{
    return bold;
}

bool
FontAttributes::GetItalic() const
{
    return italic;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
FontAttributes::SelectColor()
{
    Select(ID_color, (void *)&color);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FontAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
FontAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_font:               return "font";
    case ID_scale:              return "scale";
    case ID_useForegroundColor: return "useForegroundColor";
    case ID_color:              return "color";
    case ID_bold:               return "bold";
    case ID_italic:             return "italic";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FontAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
FontAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_font:               return FieldType_enum;
    case ID_scale:              return FieldType_double;
    case ID_useForegroundColor: return FieldType_bool;
    case ID_color:              return FieldType_color;
    case ID_bold:               return FieldType_bool;
    case ID_italic:             return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: FontAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
FontAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_font:               return "enum";
    case ID_scale:              return "double";
    case ID_useForegroundColor: return "bool";
    case ID_color:              return "color";
    case ID_bold:               return "bool";
    case ID_italic:             return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FontAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FontAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const FontAttributes &obj = *((const FontAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_font:
        {  // new scope
        retval = (font == obj.font);
        }
        break;
    case ID_scale:
        {  // new scope
        retval = (scale == obj.scale);
        }
        break;
    case ID_useForegroundColor:
        {  // new scope
        retval = (useForegroundColor == obj.useForegroundColor);
        }
        break;
    case ID_color:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case ID_bold:
        {  // new scope
        retval = (bold == obj.bold);
        }
        break;
    case ID_italic:
        {  // new scope
        retval = (italic == obj.italic);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

