// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef EXPORTDBATTRIBUTES_H
#define EXPORTDBATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <DBOptionsAttributes.h>

// ****************************************************************************
// Class: ExportDBAttributes
//
// Purpose:
//    The attributes for export a database
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ExportDBAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ExportDBAttributes();
    ExportDBAttributes(const ExportDBAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ExportDBAttributes(private_tmfs_t tmfs);
    ExportDBAttributes(const ExportDBAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ExportDBAttributes();

    virtual ExportDBAttributes& operator = (const ExportDBAttributes &obj);
    virtual bool operator == (const ExportDBAttributes &obj) const;
    virtual bool operator != (const ExportDBAttributes &obj) const;
private:
    void Init();
    void Copy(const ExportDBAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectDirname();
    void SelectFilename();
    void SelectTimeStateFormat();
    void SelectDb_type();
    void SelectDb_type_fullname();
    void SelectVariables();
    void SelectOpts();

    // Property setting methods
    void SetAllTimes(bool allTimes_);
    void SetDirname(const std::string &dirname_);
    void SetFilename(const std::string &filename_);
    void SetTimeStateFormat(const std::string &timeStateFormat_);
    void SetDb_type(const std::string &db_type_);
    void SetDb_type_fullname(const std::string &db_type_fullname_);
    void SetVariables(const stringVector &variables_);
    void SetWriteUsingGroups(bool writeUsingGroups_);
    void SetGroupSize(int groupSize_);
    void SetOpts(const DBOptionsAttributes &opts_);

    // Property getting methods
    bool                      GetAllTimes() const;
    const std::string         &GetDirname() const;
          std::string         &GetDirname();
    const std::string         &GetFilename() const;
          std::string         &GetFilename();
    const std::string         &GetTimeStateFormat() const;
          std::string         &GetTimeStateFormat();
    const std::string         &GetDb_type() const;
          std::string         &GetDb_type();
    const std::string         &GetDb_type_fullname() const;
          std::string         &GetDb_type_fullname();
    const stringVector        &GetVariables() const;
          stringVector        &GetVariables();
    bool                      GetWriteUsingGroups() const;
    int                       GetGroupSize() const;
    const DBOptionsAttributes &GetOpts() const;
          DBOptionsAttributes &GetOpts();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_allTimes = 0,
        ID_dirname,
        ID_filename,
        ID_timeStateFormat,
        ID_db_type,
        ID_db_type_fullname,
        ID_variables,
        ID_writeUsingGroups,
        ID_groupSize,
        ID_opts,
        ID__LAST
    };

private:
    bool                allTimes;
    std::string         dirname;
    std::string         filename;
    std::string         timeStateFormat;
    std::string         db_type;
    std::string         db_type_fullname;
    stringVector        variables;
    bool                writeUsingGroups;
    int                 groupSize;
    DBOptionsAttributes opts;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define EXPORTDBATTRIBUTES_TMFS "bssssss*bia"

#endif
