// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ExportDBAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ExportDBAttributes::ExportDBAttributes
//
// Purpose:
//   Init utility for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void ExportDBAttributes::Init()
{
    allTimes = false;
    dirname = ".";
    filename = "visit_ex_db";
    timeStateFormat = "_%04d";
    writeUsingGroups = false;
    groupSize = 48;

    ExportDBAttributes::SelectAll();
}

// ****************************************************************************
// Method: ExportDBAttributes::ExportDBAttributes
//
// Purpose:
//   Copy utility for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void ExportDBAttributes::Copy(const ExportDBAttributes &obj)
{
    allTimes = obj.allTimes;
    dirname = obj.dirname;
    filename = obj.filename;
    timeStateFormat = obj.timeStateFormat;
    db_type = obj.db_type;
    db_type_fullname = obj.db_type_fullname;
    variables = obj.variables;
    writeUsingGroups = obj.writeUsingGroups;
    groupSize = obj.groupSize;
    opts = obj.opts;

    ExportDBAttributes::SelectAll();
}

// Type map format string
const char *ExportDBAttributes::TypeMapFormatString = EXPORTDBATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ExportDBAttributes::TmfsStruct = {EXPORTDBATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ExportDBAttributes::ExportDBAttributes
//
// Purpose:
//   Default constructor for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ExportDBAttributes::ExportDBAttributes() :
    AttributeSubject(ExportDBAttributes::TypeMapFormatString)
{
    ExportDBAttributes::Init();
}

// ****************************************************************************
// Method: ExportDBAttributes::ExportDBAttributes
//
// Purpose:
//   Constructor for the derived classes of ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ExportDBAttributes::ExportDBAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    ExportDBAttributes::Init();
}

// ****************************************************************************
// Method: ExportDBAttributes::ExportDBAttributes
//
// Purpose:
//   Copy constructor for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ExportDBAttributes::ExportDBAttributes(const ExportDBAttributes &obj) :
    AttributeSubject(ExportDBAttributes::TypeMapFormatString)
{
    ExportDBAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ExportDBAttributes::ExportDBAttributes
//
// Purpose:
//   Copy constructor for derived classes of the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ExportDBAttributes::ExportDBAttributes(const ExportDBAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    ExportDBAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ExportDBAttributes::~ExportDBAttributes
//
// Purpose:
//   Destructor for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ExportDBAttributes::~ExportDBAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ExportDBAttributes::operator =
//
// Purpose:
//   Assignment operator for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

ExportDBAttributes&
ExportDBAttributes::operator = (const ExportDBAttributes &obj)
{
    if (this == &obj) return *this;

    ExportDBAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ExportDBAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExportDBAttributes::operator == (const ExportDBAttributes &obj) const
{
    // Create the return value
    return ((allTimes == obj.allTimes) &&
            (dirname == obj.dirname) &&
            (filename == obj.filename) &&
            (timeStateFormat == obj.timeStateFormat) &&
            (db_type == obj.db_type) &&
            (db_type_fullname == obj.db_type_fullname) &&
            (variables == obj.variables) &&
            (writeUsingGroups == obj.writeUsingGroups) &&
            (groupSize == obj.groupSize) &&
            (opts == obj.opts));
}

// ****************************************************************************
// Method: ExportDBAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExportDBAttributes::operator != (const ExportDBAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ExportDBAttributes::TypeName
//
// Purpose:
//   Type name method for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
ExportDBAttributes::TypeName() const
{
    return "ExportDBAttributes";
}

// ****************************************************************************
// Method: ExportDBAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExportDBAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ExportDBAttributes *tmp = (const ExportDBAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ExportDBAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
ExportDBAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ExportDBAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: ExportDBAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the ExportDBAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
ExportDBAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ExportDBAttributes(*this);
    else
        retval = new ExportDBAttributes;

    return retval;
}

// ****************************************************************************
// Method: ExportDBAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExportDBAttributes::SelectAll()
{
    Select(ID_allTimes,         (void *)&allTimes);
    Select(ID_dirname,          (void *)&dirname);
    Select(ID_filename,         (void *)&filename);
    Select(ID_timeStateFormat,  (void *)&timeStateFormat);
    Select(ID_db_type,          (void *)&db_type);
    Select(ID_db_type_fullname, (void *)&db_type_fullname);
    Select(ID_variables,        (void *)&variables);
    Select(ID_writeUsingGroups, (void *)&writeUsingGroups);
    Select(ID_groupSize,        (void *)&groupSize);
    Select(ID_opts,             (void *)&opts);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ExportDBAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExportDBAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ExportDBAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ExportDBAttributes.
    DataNode *node = new DataNode("ExportDBAttributes");

    if(completeSave || !FieldsEqual(ID_allTimes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("allTimes", allTimes));
    }

    if(completeSave || !FieldsEqual(ID_dirname, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dirname", dirname));
    }

    if(completeSave || !FieldsEqual(ID_filename, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("filename", filename));
    }

    if(completeSave || !FieldsEqual(ID_timeStateFormat, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeStateFormat", timeStateFormat));
    }

    if(completeSave || !FieldsEqual(ID_db_type, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("db_type", db_type));
    }

    if(completeSave || !FieldsEqual(ID_db_type_fullname, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("db_type_fullname", db_type_fullname));
    }

    if(completeSave || !FieldsEqual(ID_variables, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variables", variables));
    }

    if(completeSave || !FieldsEqual(ID_writeUsingGroups, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("writeUsingGroups", writeUsingGroups));
    }

    if(completeSave || !FieldsEqual(ID_groupSize, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("groupSize", groupSize));
    }

    if(completeSave || !FieldsEqual(ID_opts, &defaultObject))
    {
        DataNode *optsNode = new DataNode("opts");
        if(opts.CreateNode(optsNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(optsNode);
        }
        else
            delete optsNode;
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ExportDBAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExportDBAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ExportDBAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("allTimes")) != 0)
        SetAllTimes(node->AsBool());
    if((node = searchNode->GetNode("dirname")) != 0)
        SetDirname(node->AsString());
    if((node = searchNode->GetNode("filename")) != 0)
        SetFilename(node->AsString());
    if((node = searchNode->GetNode("timeStateFormat")) != 0)
        SetTimeStateFormat(node->AsString());
    if((node = searchNode->GetNode("db_type")) != 0)
        SetDb_type(node->AsString());
    if((node = searchNode->GetNode("db_type_fullname")) != 0)
        SetDb_type_fullname(node->AsString());
    if((node = searchNode->GetNode("variables")) != 0)
        SetVariables(node->AsStringVector());
    if((node = searchNode->GetNode("writeUsingGroups")) != 0)
        SetWriteUsingGroups(node->AsBool());
    if((node = searchNode->GetNode("groupSize")) != 0)
        SetGroupSize(node->AsInt());
    if((node = searchNode->GetNode("opts")) != 0)
        opts.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ExportDBAttributes::SetAllTimes(bool allTimes_)
{
    allTimes = allTimes_;
    Select(ID_allTimes, (void *)&allTimes);
}

void
ExportDBAttributes::SetDirname(const std::string &dirname_)
{
    dirname = dirname_;
    Select(ID_dirname, (void *)&dirname);
}

void
ExportDBAttributes::SetFilename(const std::string &filename_)
{
    filename = filename_;
    Select(ID_filename, (void *)&filename);
}

void
ExportDBAttributes::SetTimeStateFormat(const std::string &timeStateFormat_)
{
    timeStateFormat = timeStateFormat_;
    Select(ID_timeStateFormat, (void *)&timeStateFormat);
}

void
ExportDBAttributes::SetDb_type(const std::string &db_type_)
{
    db_type = db_type_;
    Select(ID_db_type, (void *)&db_type);
}

void
ExportDBAttributes::SetDb_type_fullname(const std::string &db_type_fullname_)
{
    db_type_fullname = db_type_fullname_;
    Select(ID_db_type_fullname, (void *)&db_type_fullname);
}

void
ExportDBAttributes::SetVariables(const stringVector &variables_)
{
    variables = variables_;
    Select(ID_variables, (void *)&variables);
}

void
ExportDBAttributes::SetWriteUsingGroups(bool writeUsingGroups_)
{
    writeUsingGroups = writeUsingGroups_;
    Select(ID_writeUsingGroups, (void *)&writeUsingGroups);
}

void
ExportDBAttributes::SetGroupSize(int groupSize_)
{
    groupSize = groupSize_;
    Select(ID_groupSize, (void *)&groupSize);
}

void
ExportDBAttributes::SetOpts(const DBOptionsAttributes &opts_)
{
    opts = opts_;
    Select(ID_opts, (void *)&opts);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
ExportDBAttributes::GetAllTimes() const
{
    return allTimes;
}

const std::string &
ExportDBAttributes::GetDirname() const
{
    return dirname;
}

std::string &
ExportDBAttributes::GetDirname()
{
    return dirname;
}

const std::string &
ExportDBAttributes::GetFilename() const
{
    return filename;
}

std::string &
ExportDBAttributes::GetFilename()
{
    return filename;
}

const std::string &
ExportDBAttributes::GetTimeStateFormat() const
{
    return timeStateFormat;
}

std::string &
ExportDBAttributes::GetTimeStateFormat()
{
    return timeStateFormat;
}

const std::string &
ExportDBAttributes::GetDb_type() const
{
    return db_type;
}

std::string &
ExportDBAttributes::GetDb_type()
{
    return db_type;
}

const std::string &
ExportDBAttributes::GetDb_type_fullname() const
{
    return db_type_fullname;
}

std::string &
ExportDBAttributes::GetDb_type_fullname()
{
    return db_type_fullname;
}

const stringVector &
ExportDBAttributes::GetVariables() const
{
    return variables;
}

stringVector &
ExportDBAttributes::GetVariables()
{
    return variables;
}

bool
ExportDBAttributes::GetWriteUsingGroups() const
{
    return writeUsingGroups;
}

int
ExportDBAttributes::GetGroupSize() const
{
    return groupSize;
}

const DBOptionsAttributes &
ExportDBAttributes::GetOpts() const
{
    return opts;
}

DBOptionsAttributes &
ExportDBAttributes::GetOpts()
{
    return opts;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ExportDBAttributes::SelectDirname()
{
    Select(ID_dirname, (void *)&dirname);
}

void
ExportDBAttributes::SelectFilename()
{
    Select(ID_filename, (void *)&filename);
}

void
ExportDBAttributes::SelectTimeStateFormat()
{
    Select(ID_timeStateFormat, (void *)&timeStateFormat);
}

void
ExportDBAttributes::SelectDb_type()
{
    Select(ID_db_type, (void *)&db_type);
}

void
ExportDBAttributes::SelectDb_type_fullname()
{
    Select(ID_db_type_fullname, (void *)&db_type_fullname);
}

void
ExportDBAttributes::SelectVariables()
{
    Select(ID_variables, (void *)&variables);
}

void
ExportDBAttributes::SelectOpts()
{
    Select(ID_opts, (void *)&opts);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ExportDBAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
ExportDBAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_allTimes:         return "allTimes";
    case ID_dirname:          return "dirname";
    case ID_filename:         return "filename";
    case ID_timeStateFormat:  return "timeStateFormat";
    case ID_db_type:          return "db_type";
    case ID_db_type_fullname: return "db_type_fullname";
    case ID_variables:        return "variables";
    case ID_writeUsingGroups: return "writeUsingGroups";
    case ID_groupSize:        return "groupSize";
    case ID_opts:             return "opts";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ExportDBAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
ExportDBAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_allTimes:         return FieldType_bool;
    case ID_dirname:          return FieldType_string;
    case ID_filename:         return FieldType_string;
    case ID_timeStateFormat:  return FieldType_string;
    case ID_db_type:          return FieldType_string;
    case ID_db_type_fullname: return FieldType_string;
    case ID_variables:        return FieldType_stringVector;
    case ID_writeUsingGroups: return FieldType_bool;
    case ID_groupSize:        return FieldType_int;
    case ID_opts:             return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ExportDBAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
ExportDBAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_allTimes:         return "bool";
    case ID_dirname:          return "string";
    case ID_filename:         return "string";
    case ID_timeStateFormat:  return "string";
    case ID_db_type:          return "string";
    case ID_db_type_fullname: return "string";
    case ID_variables:        return "stringVector";
    case ID_writeUsingGroups: return "bool";
    case ID_groupSize:        return "int";
    case ID_opts:             return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ExportDBAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExportDBAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ExportDBAttributes &obj = *((const ExportDBAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_allTimes:
        {  // new scope
        retval = (allTimes == obj.allTimes);
        }
        break;
    case ID_dirname:
        {  // new scope
        retval = (dirname == obj.dirname);
        }
        break;
    case ID_filename:
        {  // new scope
        retval = (filename == obj.filename);
        }
        break;
    case ID_timeStateFormat:
        {  // new scope
        retval = (timeStateFormat == obj.timeStateFormat);
        }
        break;
    case ID_db_type:
        {  // new scope
        retval = (db_type == obj.db_type);
        }
        break;
    case ID_db_type_fullname:
        {  // new scope
        retval = (db_type_fullname == obj.db_type_fullname);
        }
        break;
    case ID_variables:
        {  // new scope
        retval = (variables == obj.variables);
        }
        break;
    case ID_writeUsingGroups:
        {  // new scope
        retval = (writeUsingGroups == obj.writeUsingGroups);
        }
        break;
    case ID_groupSize:
        {  // new scope
        retval = (groupSize == obj.groupSize);
        }
        break;
    case ID_opts:
        {  // new scope
        retval = (opts == obj.opts);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

