// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef CONTOUROPATTRIBUTES_H
#define CONTOUROPATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ContourOpAttributes
//
// Purpose:
//    This class contains the operator attributes for the contour operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ContourOpAttributes : public AttributeSubject
{
public:
    enum ContourMethod
    {
        Level,
        Value,
        Percent
    };
    enum ContourScaling
    {
        Linear,
        Log
    };

    // These constructors are for objects of this class
    ContourOpAttributes();
    ContourOpAttributes(const ContourOpAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ContourOpAttributes(private_tmfs_t tmfs);
    ContourOpAttributes(const ContourOpAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ContourOpAttributes();

    virtual ContourOpAttributes& operator = (const ContourOpAttributes &obj);
    virtual bool operator == (const ContourOpAttributes &obj) const;
    virtual bool operator != (const ContourOpAttributes &obj) const;
private:
    void Init();
    void Copy(const ContourOpAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectContourValue();
    void SelectContourPercent();
    void SelectVariable();

    // Property setting methods
    void SetContourNLevels(int contourNLevels_);
    void SetContourValue(const doubleVector &contourValue_);
    void SetContourPercent(const doubleVector &contourPercent_);
    void SetContourMethod(ContourMethod contourMethod_);
    void SetMinFlag(bool minFlag_);
    void SetMaxFlag(bool maxFlag_);
    void SetMin(double min_);
    void SetMax(double max_);
    void SetScaling(ContourScaling scaling_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    int                GetContourNLevels() const;
    const doubleVector &GetContourValue() const;
          doubleVector &GetContourValue();
    const doubleVector &GetContourPercent() const;
          doubleVector &GetContourPercent();
    ContourMethod      GetContourMethod() const;
    bool               GetMinFlag() const;
    bool               GetMaxFlag() const;
    double             GetMin() const;
    double             GetMax() const;
    ContourScaling     GetScaling() const;
    const std::string  &GetVariable() const;
          std::string  &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string ContourMethod_ToString(ContourMethod);
    static bool ContourMethod_FromString(const std::string &, ContourMethod &);
protected:
    static std::string ContourMethod_ToString(int);
public:
    static std::string ContourScaling_ToString(ContourScaling);
    static bool ContourScaling_FromString(const std::string &, ContourScaling &);
protected:
    static std::string ContourScaling_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_contourNLevels = 0,
        ID_contourValue,
        ID_contourPercent,
        ID_contourMethod,
        ID_minFlag,
        ID_maxFlag,
        ID_min,
        ID_max,
        ID_scaling,
        ID_variable,
        ID__LAST
    };

private:
    int          contourNLevels;
    doubleVector contourValue;
    doubleVector contourPercent;
    int          contourMethod;
    bool         minFlag;
    bool         maxFlag;
    double       min;
    double       max;
    int          scaling;
    std::string  variable;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define CONTOUROPATTRIBUTES_TMFS "id*d*ibbddis"

#endif
