// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef COLORATTRIBUTELIST_H
#define COLORATTRIBUTELIST_H
#include <state_exports.h>
#include <AttributeSubject.h>

class ColorAttribute;

// ****************************************************************************
// Class: ColorAttributeList
//
// Purpose:
//    This class contains a list of ColorAttributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ColorAttributeList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ColorAttributeList();
    ColorAttributeList(const ColorAttributeList &obj);
protected:
    // These constructors are for objects derived from this class
    ColorAttributeList(private_tmfs_t tmfs);
    ColorAttributeList(const ColorAttributeList &obj, private_tmfs_t tmfs);
public:
    virtual ~ColorAttributeList();

    virtual ColorAttributeList& operator = (const ColorAttributeList &obj);
    virtual bool operator == (const ColorAttributeList &obj) const;
    virtual bool operator != (const ColorAttributeList &obj) const;
private:
    void Init();
    void Copy(const ColorAttributeList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectColors();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetColors() const;
          AttributeGroupVector &GetColors();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddColors(const ColorAttribute &);
    void ClearColors();
    void RemoveColors(int i);
    int  GetNumColors() const;
    ColorAttribute &GetColors(int i);
    const ColorAttribute &GetColors(int i) const;

    ColorAttribute &operator [] (int i);
    const ColorAttribute &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_colors = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector colors;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define COLORATTRIBUTELIST_TMFS "a*"

#endif
