// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AXISTITLES_H
#define AXISTITLES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <FontAttributes.h>

// ****************************************************************************
// Class: AxisTitles
//
// Purpose:
//    Contains the title properties for one axis.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API AxisTitles : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    AxisTitles();
    AxisTitles(const AxisTitles &obj);
protected:
    // These constructors are for objects derived from this class
    AxisTitles(private_tmfs_t tmfs);
    AxisTitles(const AxisTitles &obj, private_tmfs_t tmfs);
public:
    virtual ~AxisTitles();

    virtual AxisTitles& operator = (const AxisTitles &obj);
    virtual bool operator == (const AxisTitles &obj) const;
    virtual bool operator != (const AxisTitles &obj) const;
private:
    void Init();
    void Copy(const AxisTitles &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectFont();
    void SelectTitle();
    void SelectUnits();

    // Property setting methods
    void SetVisible(bool visible_);
    void SetFont(const FontAttributes &font_);
    void SetUserTitle(bool userTitle_);
    void SetUserUnits(bool userUnits_);
    void SetTitle(const std::string &title_);
    void SetUnits(const std::string &units_);

    // Property getting methods
    bool                 GetVisible() const;
    const FontAttributes &GetFont() const;
          FontAttributes &GetFont();
    bool                 GetUserTitle() const;
    bool                 GetUserUnits() const;
    const std::string    &GetTitle() const;
          std::string    &GetTitle();
    const std::string    &GetUnits() const;
          std::string    &GetUnits();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_visible = 0,
        ID_font,
        ID_userTitle,
        ID_userUnits,
        ID_title,
        ID_units,
        ID__LAST
    };

private:
    bool           visible;
    FontAttributes font;
    bool           userTitle;
    bool           userUnits;
    std::string    title;
    std::string    units;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AXISTITLES_TMFS "babbss"

#endif
