// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AXISRESTRICTIONATTRIBUTES_H
#define AXISRESTRICTIONATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: AxisRestrictionAttributes
//
// Purpose:
//    Attributes for axis restrictions
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API AxisRestrictionAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    AxisRestrictionAttributes();
    AxisRestrictionAttributes(const AxisRestrictionAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    AxisRestrictionAttributes(private_tmfs_t tmfs);
    AxisRestrictionAttributes(const AxisRestrictionAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~AxisRestrictionAttributes();

    virtual AxisRestrictionAttributes& operator = (const AxisRestrictionAttributes &obj);
    virtual bool operator == (const AxisRestrictionAttributes &obj) const;
    virtual bool operator != (const AxisRestrictionAttributes &obj) const;
private:
    void Init();
    void Copy(const AxisRestrictionAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectNames();
    void SelectMinima();
    void SelectMaxima();

    // Property setting methods
    void SetNames(const stringVector &names_);
    void SetMinima(const doubleVector &minima_);
    void SetMaxima(const doubleVector &maxima_);

    // Property getting methods
    const stringVector &GetNames() const;
          stringVector &GetNames();
    const doubleVector &GetMinima() const;
          doubleVector &GetMinima();
    const doubleVector &GetMaxima() const;
          doubleVector &GetMaxima();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_names = 0,
        ID_minima,
        ID_maxima,
        ID__LAST
    };

private:
    stringVector names;
    doubleVector minima;
    doubleVector maxima;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AXISRESTRICTIONATTRIBUTES_TMFS "s*d*d*"

#endif
