// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <AxesArray.h>
#include <DataNode.h>

// ****************************************************************************
// Method: AxesArray::AxesArray
//
// Purpose:
//   Init utility for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void AxesArray::Init()
{
    visible = true;
    ticksVisible = true;
    autoSetTicks = true;
    autoSetScaling = true;
    lineWidth = 0;
    //axes.GetTitle().SetTitle("");

    AxesArray::SelectAll();
}

// ****************************************************************************
// Method: AxesArray::AxesArray
//
// Purpose:
//   Copy utility for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void AxesArray::Copy(const AxesArray &obj)
{
    visible = obj.visible;
    ticksVisible = obj.ticksVisible;
    autoSetTicks = obj.autoSetTicks;
    autoSetScaling = obj.autoSetScaling;
    lineWidth = obj.lineWidth;
    axes = obj.axes;

    AxesArray::SelectAll();
}

// Type map format string
const char *AxesArray::TypeMapFormatString = AXESARRAY_TMFS;
const AttributeGroup::private_tmfs_t AxesArray::TmfsStruct = {AXESARRAY_TMFS};


// ****************************************************************************
// Method: AxesArray::AxesArray
//
// Purpose:
//   Default constructor for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AxesArray::AxesArray() :
    AttributeSubject(AxesArray::TypeMapFormatString)
{
    AxesArray::Init();
}

// ****************************************************************************
// Method: AxesArray::AxesArray
//
// Purpose:
//   Constructor for the derived classes of AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AxesArray::AxesArray(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    AxesArray::Init();
}

// ****************************************************************************
// Method: AxesArray::AxesArray
//
// Purpose:
//   Copy constructor for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AxesArray::AxesArray(const AxesArray &obj) :
    AttributeSubject(AxesArray::TypeMapFormatString)
{
    AxesArray::Copy(obj);
}

// ****************************************************************************
// Method: AxesArray::AxesArray
//
// Purpose:
//   Copy constructor for derived classes of the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AxesArray::AxesArray(const AxesArray &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    AxesArray::Copy(obj);
}

// ****************************************************************************
// Method: AxesArray::~AxesArray
//
// Purpose:
//   Destructor for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AxesArray::~AxesArray()
{
    // nothing here
}

// ****************************************************************************
// Method: AxesArray::operator =
//
// Purpose:
//   Assignment operator for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AxesArray&
AxesArray::operator = (const AxesArray &obj)
{
    if (this == &obj) return *this;

    AxesArray::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AxesArray::operator ==
//
// Purpose:
//   Comparison operator == for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AxesArray::operator == (const AxesArray &obj) const
{
    // Create the return value
    return ((visible == obj.visible) &&
            (ticksVisible == obj.ticksVisible) &&
            (autoSetTicks == obj.autoSetTicks) &&
            (autoSetScaling == obj.autoSetScaling) &&
            (lineWidth == obj.lineWidth) &&
            (axes == obj.axes));
}

// ****************************************************************************
// Method: AxesArray::operator !=
//
// Purpose:
//   Comparison operator != for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AxesArray::operator != (const AxesArray &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AxesArray::TypeName
//
// Purpose:
//   Type name method for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
AxesArray::TypeName() const
{
    return "AxesArray";
}

// ****************************************************************************
// Method: AxesArray::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AxesArray::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AxesArray *tmp = (const AxesArray *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AxesArray::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
AxesArray::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AxesArray(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: AxesArray::NewInstance
//
// Purpose:
//   NewInstance method for the AxesArray class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
AxesArray::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AxesArray(*this);
    else
        retval = new AxesArray;

    return retval;
}

// ****************************************************************************
// Method: AxesArray::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AxesArray::SelectAll()
{
    Select(ID_visible,        (void *)&visible);
    Select(ID_ticksVisible,   (void *)&ticksVisible);
    Select(ID_autoSetTicks,   (void *)&autoSetTicks);
    Select(ID_autoSetScaling, (void *)&autoSetScaling);
    Select(ID_lineWidth,      (void *)&lineWidth);
    Select(ID_axes,           (void *)&axes);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxesArray::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AxesArray::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AxesArray defaultObject;
    bool addToParent = false;
    // Create a node for AxesArray.
    DataNode *node = new DataNode("AxesArray");

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(ID_ticksVisible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ticksVisible", ticksVisible));
    }

    if(completeSave || !FieldsEqual(ID_autoSetTicks, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoSetTicks", autoSetTicks));
    }

    if(completeSave || !FieldsEqual(ID_autoSetScaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoSetScaling", autoSetScaling));
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(ID_axes, &defaultObject))
    {
        DataNode *axesNode = new DataNode("axes");
        if(axes.CreateNode(axesNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(axesNode);
        }
        else
            delete axesNode;
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AxesArray::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AxesArray::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AxesArray");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("ticksVisible")) != 0)
        SetTicksVisible(node->AsBool());
    if((node = searchNode->GetNode("autoSetTicks")) != 0)
        SetAutoSetTicks(node->AsBool());
    if((node = searchNode->GetNode("autoSetScaling")) != 0)
        SetAutoSetScaling(node->AsBool());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("axes")) != 0)
        axes.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AxesArray::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

void
AxesArray::SetTicksVisible(bool ticksVisible_)
{
    ticksVisible = ticksVisible_;
    Select(ID_ticksVisible, (void *)&ticksVisible);
}

void
AxesArray::SetAutoSetTicks(bool autoSetTicks_)
{
    autoSetTicks = autoSetTicks_;
    Select(ID_autoSetTicks, (void *)&autoSetTicks);
}

void
AxesArray::SetAutoSetScaling(bool autoSetScaling_)
{
    autoSetScaling = autoSetScaling_;
    Select(ID_autoSetScaling, (void *)&autoSetScaling);
}

void
AxesArray::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
AxesArray::SetAxes(const AxisAttributes &axes_)
{
    axes = axes_;
    Select(ID_axes, (void *)&axes);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AxesArray::GetVisible() const
{
    return visible;
}

bool
AxesArray::GetTicksVisible() const
{
    return ticksVisible;
}

bool
AxesArray::GetAutoSetTicks() const
{
    return autoSetTicks;
}

bool
AxesArray::GetAutoSetScaling() const
{
    return autoSetScaling;
}

int
AxesArray::GetLineWidth() const
{
    return lineWidth;
}

const AxisAttributes &
AxesArray::GetAxes() const
{
    return axes;
}

AxisAttributes &
AxesArray::GetAxes()
{
    return axes;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AxesArray::SelectAxes()
{
    Select(ID_axes, (void *)&axes);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxesArray::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
AxesArray::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_visible:        return "visible";
    case ID_ticksVisible:   return "ticksVisible";
    case ID_autoSetTicks:   return "autoSetTicks";
    case ID_autoSetScaling: return "autoSetScaling";
    case ID_lineWidth:      return "lineWidth";
    case ID_axes:           return "axes";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxesArray::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
AxesArray::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_visible:        return FieldType_bool;
    case ID_ticksVisible:   return FieldType_bool;
    case ID_autoSetTicks:   return FieldType_bool;
    case ID_autoSetScaling: return FieldType_bool;
    case ID_lineWidth:      return FieldType_linewidth;
    case ID_axes:           return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AxesArray::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
AxesArray::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_visible:        return "bool";
    case ID_ticksVisible:   return "bool";
    case ID_autoSetTicks:   return "bool";
    case ID_autoSetScaling: return "bool";
    case ID_lineWidth:      return "linewidth";
    case ID_axes:           return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxesArray::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AxesArray::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AxesArray &obj = *((const AxesArray*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case ID_ticksVisible:
        {  // new scope
        retval = (ticksVisible == obj.ticksVisible);
        }
        break;
    case ID_autoSetTicks:
        {  // new scope
        retval = (autoSetTicks == obj.autoSetTicks);
        }
        break;
    case ID_autoSetScaling:
        {  // new scope
        retval = (autoSetScaling == obj.autoSetScaling);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_axes:
        {  // new scope
        retval = (axes == obj.axes);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

