// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AXES2D_H
#define AXES2D_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <AxisAttributes.h>

// ****************************************************************************
// Class: Axes2D
//
// Purpose:
//    Contains the properties for the 2D axes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API Axes2D : public AttributeSubject
{
public:
    enum Ticks
    {
        Off,
        Bottom,
        Left,
        BottomLeft,
        All
    };
    enum Location
    {
        Inside,
        Outside,
        Both
    };

    // These constructors are for objects of this class
    Axes2D();
    Axes2D(const Axes2D &obj);
protected:
    // These constructors are for objects derived from this class
    Axes2D(private_tmfs_t tmfs);
    Axes2D(const Axes2D &obj, private_tmfs_t tmfs);
public:
    virtual ~Axes2D();

    virtual Axes2D& operator = (const Axes2D &obj);
    virtual bool operator == (const Axes2D &obj) const;
    virtual bool operator != (const Axes2D &obj) const;
private:
    void Init();
    void Copy(const Axes2D &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectXAxis();
    void SelectYAxis();

    // Property setting methods
    void SetVisible(bool visible_);
    void SetAutoSetTicks(bool autoSetTicks_);
    void SetAutoSetScaling(bool autoSetScaling_);
    void SetLineWidth(int lineWidth_);
    void SetTickLocation(Location tickLocation_);
    void SetTickAxes(Ticks tickAxes_);
    void SetXAxis(const AxisAttributes &xAxis_);
    void SetYAxis(const AxisAttributes &yAxis_);

    // Property getting methods
    bool                 GetVisible() const;
    bool                 GetAutoSetTicks() const;
    bool                 GetAutoSetScaling() const;
    int                  GetLineWidth() const;
    Location             GetTickLocation() const;
    Ticks                GetTickAxes() const;
    const AxisAttributes &GetXAxis() const;
          AxisAttributes &GetXAxis();
    const AxisAttributes &GetYAxis() const;
          AxisAttributes &GetYAxis();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Ticks_ToString(Ticks);
    static bool Ticks_FromString(const std::string &, Ticks &);
protected:
    static std::string Ticks_ToString(int);
public:
    static std::string Location_ToString(Location);
    static bool Location_FromString(const std::string &, Location &);
protected:
    static std::string Location_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_visible = 0,
        ID_autoSetTicks,
        ID_autoSetScaling,
        ID_lineWidth,
        ID_tickLocation,
        ID_tickAxes,
        ID_xAxis,
        ID_yAxis,
        ID__LAST
    };

private:
    bool           visible;
    bool           autoSetTicks;
    bool           autoSetScaling;
    int            lineWidth;
    int            tickLocation;
    int            tickAxes;
    AxisAttributes xAxis;
    AxisAttributes yAxis;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AXES2D_TMFS "bbbiiiaa"

#endif
