// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ANNOTATIONOBJECTLIST_H
#define ANNOTATIONOBJECTLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>

class AnnotationObject;

// ****************************************************************************
// Class: AnnotationObjectList
//
// Purpose:
//    Contains a list of AnnotationObjectAttributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API AnnotationObjectList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    AnnotationObjectList();
    AnnotationObjectList(const AnnotationObjectList &obj);
protected:
    // These constructors are for objects derived from this class
    AnnotationObjectList(private_tmfs_t tmfs);
    AnnotationObjectList(const AnnotationObjectList &obj, private_tmfs_t tmfs);
public:
    virtual ~AnnotationObjectList();

    virtual AnnotationObjectList& operator = (const AnnotationObjectList &obj);
    virtual bool operator == (const AnnotationObjectList &obj) const;
    virtual bool operator != (const AnnotationObjectList &obj) const;
private:
    void Init();
    void Copy(const AnnotationObjectList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectAnnotation();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetAnnotation() const;
          AttributeGroupVector &GetAnnotation();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddAnnotation(const AnnotationObject &);
    void ClearAnnotations();
    void RemoveAnnotation(int i);
    int  GetNumAnnotations() const;
    AnnotationObject &GetAnnotation(int i);
    const AnnotationObject &GetAnnotation(int i) const;

    AnnotationObject &operator [] (int i);
    const AnnotationObject &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    virtual void ProcessOldVersions(DataNode *parentNode, const char *configVersion);
    bool RemoveAnnotation(const std::string &);
    std::string GetNewObjectName() const;
    int IndexForName(const std::string &name) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_annotation = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector annotation;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ANNOTATIONOBJECTLIST_TMFS "a*"

#endif
