// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ANNOTATIONOBJECT_H
#define ANNOTATIONOBJECT_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <ColorAttribute.h>

// ****************************************************************************
// Class: AnnotationObject
//
// Purpose:
//    This class defines a general set of attributes that are used to set the attributes for all annotation objects.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API AnnotationObject : public AttributeSubject
{
public:
    enum AnnotationType
    {
        Text2D,
        Text3D,
        TimeSlider,
        Line2D,
        Line3D,
        Arrow2D,
        Arrow3D,
        Box,
        Image,
        LegendAttributes,
        MaxAnnotationType
    };
    enum FontFamily
    {
        Arial,
        Courier,
        Times
    };

    // These constructors are for objects of this class
    AnnotationObject();
    AnnotationObject(const AnnotationObject &obj);
protected:
    // These constructors are for objects derived from this class
    AnnotationObject(private_tmfs_t tmfs);
    AnnotationObject(const AnnotationObject &obj, private_tmfs_t tmfs);
public:
    virtual ~AnnotationObject();

    virtual AnnotationObject& operator = (const AnnotationObject &obj);
    virtual bool operator == (const AnnotationObject &obj) const;
    virtual bool operator != (const AnnotationObject &obj) const;
private:
    void Init();
    void Copy(const AnnotationObject &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectObjectName();
    void SelectPosition();
    void SelectPosition2();
    void SelectTextColor();
    void SelectColor1();
    void SelectColor2();
    void SelectText();
    void SelectOptions();

    // Property setting methods
    void SetObjectName(const std::string &objectName_);
    void SetObjectType(AnnotationType objectType_);
    void SetVisible(bool visible_);
    void SetActive(bool active_);
    void SetPosition(const double *position_);
    void SetPosition2(const double *position2_);
    void SetTextColor(const ColorAttribute &textColor_);
    void SetUseForegroundForTextColor(bool useForegroundForTextColor_);
    void SetColor1(const ColorAttribute &color1_);
    void SetColor2(const ColorAttribute &color2_);
    void SetText(const stringVector &text_);
    void SetFontFamily(FontFamily fontFamily_);
    void SetFontBold(bool fontBold_);
    void SetFontItalic(bool fontItalic_);
    void SetFontShadow(bool fontShadow_);
    void SetDoubleAttribute1(double doubleAttribute1_);
    void SetIntAttribute1(int intAttribute1_);
    void SetOptions(const MapNode &options_);

    // Property getting methods
    const std::string    &GetObjectName() const;
          std::string    &GetObjectName();
    AnnotationType       GetObjectType() const;
    bool                 GetVisible() const;
    bool                 GetActive() const;
    const double         *GetPosition() const;
          double         *GetPosition();
    const double         *GetPosition2() const;
          double         *GetPosition2();
    const ColorAttribute &GetTextColor() const;
          ColorAttribute &GetTextColor();
    bool                 GetUseForegroundForTextColor() const;
    const ColorAttribute &GetColor1() const;
          ColorAttribute &GetColor1();
    const ColorAttribute &GetColor2() const;
          ColorAttribute &GetColor2();
    const stringVector   &GetText() const;
          stringVector   &GetText();
    FontFamily           GetFontFamily() const;
    bool                 GetFontBold() const;
    bool                 GetFontItalic() const;
    bool                 GetFontShadow() const;
    double               GetDoubleAttribute1() const;
    int                  GetIntAttribute1() const;
    const MapNode        &GetOptions() const;
          MapNode        &GetOptions();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string AnnotationType_ToString(AnnotationType);
    static bool AnnotationType_FromString(const std::string &, AnnotationType &);
protected:
    static std::string AnnotationType_ToString(int);
public:
    static std::string FontFamily_ToString(FontFamily);
    static bool FontFamily_FromString(const std::string &, FontFamily &);
protected:
    static std::string FontFamily_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    virtual void ProcessOldVersions(DataNode *parentNode, const char *configVersion);
    void ProcessOldLegend(DataNode *searchNode, const char *configVersion);
    void ProcessOldLine3D(DataNode *searchNode);
    void ProcessOldLine2D(DataNode *searchNode);
    void ProcessOldText3D(DataNode *searchNode);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_objectName = 0,
        ID_objectType,
        ID_visible,
        ID_active,
        ID_position,
        ID_position2,
        ID_textColor,
        ID_useForegroundForTextColor,
        ID_color1,
        ID_color2,
        ID_text,
        ID_fontFamily,
        ID_fontBold,
        ID_fontItalic,
        ID_fontShadow,
        ID_doubleAttribute1,
        ID_intAttribute1,
        ID_options,
        ID__LAST
    };

private:
    std::string    objectName;
    int            objectType;
    bool           visible;
    bool           active;
    double         position[3];
    double         position2[3];
    ColorAttribute textColor;
    bool           useForegroundForTextColor;
    ColorAttribute color1;
    ColorAttribute color2;
    stringVector   text;
    int            fontFamily;
    bool           fontBold;
    bool           fontItalic;
    bool           fontShadow;
    double         doubleAttribute1;
    int            intAttribute1;
    MapNode        options;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ANNOTATIONOBJECT_TMFS "sibbDDabaas*ibbbdim"

#endif
