// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <MinMaxInfo.h>
#include <DataNode.h>
#include <avtVector.h>

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose:
//   Init utility for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void MinMaxInfo::Init()
{
    elementNum = -1;
    domain = -1;
    mvalue = 0;

    MinMaxInfo::SelectAll();
}

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose:
//   Copy utility for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void MinMaxInfo::Copy(const MinMaxInfo &obj)
{
    elementNum = obj.elementNum;
    domain = obj.domain;
    mvalue = obj.mvalue;
    coord[0] = obj.coord[0];
    coord[1] = obj.coord[1];
    coord[2] = obj.coord[2];

    type = obj.type;
    matName = obj.matName;

    MinMaxInfo::SelectAll();
}

// Type map format string
const char *MinMaxInfo::TypeMapFormatString = MINMAXINFO_TMFS;
const AttributeGroup::private_tmfs_t MinMaxInfo::TmfsStruct = {MINMAXINFO_TMFS};


// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose:
//   Default constructor for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MinMaxInfo::MinMaxInfo() :
    AttributeSubject(MinMaxInfo::TypeMapFormatString)
{
    MinMaxInfo::Init();
}

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose:
//   Constructor for the derived classes of MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MinMaxInfo::MinMaxInfo(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    MinMaxInfo::Init();
}

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose:
//   Copy constructor for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MinMaxInfo::MinMaxInfo(const MinMaxInfo &obj) :
    AttributeSubject(MinMaxInfo::TypeMapFormatString)
{
    MinMaxInfo::Copy(obj);
}

// ****************************************************************************
// Method: MinMaxInfo::MinMaxInfo
//
// Purpose:
//   Copy constructor for derived classes of the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MinMaxInfo::MinMaxInfo(const MinMaxInfo &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    MinMaxInfo::Copy(obj);
}

// ****************************************************************************
// Method: MinMaxInfo::~MinMaxInfo
//
// Purpose:
//   Destructor for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MinMaxInfo::~MinMaxInfo()
{
    // nothing here
}

// ****************************************************************************
// Method: MinMaxInfo::operator =
//
// Purpose:
//   Assignment operator for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

MinMaxInfo&
MinMaxInfo::operator = (const MinMaxInfo &obj)
{
    if (this == &obj) return *this;

    MinMaxInfo::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: MinMaxInfo::operator ==
//
// Purpose:
//   Comparison operator == for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MinMaxInfo::operator == (const MinMaxInfo &obj) const
{
    // Compare the coord arrays.
    bool coord_equal = true;
    for(int i = 0; i < 3 && coord_equal; ++i)
        coord_equal = (coord[i] == obj.coord[i]);

    // Create the return value
    return ((elementNum == obj.elementNum) &&
            (domain == obj.domain) &&
            (mvalue == obj.mvalue) &&
            coord_equal &&
            (type == obj.type) &&
            (matName == obj.matName));
}

// ****************************************************************************
// Method: MinMaxInfo::operator !=
//
// Purpose:
//   Comparison operator != for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MinMaxInfo::operator != (const MinMaxInfo &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MinMaxInfo::TypeName
//
// Purpose:
//   Type name method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
MinMaxInfo::TypeName() const
{
    return "MinMaxInfo";
}

// ****************************************************************************
// Method: MinMaxInfo::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MinMaxInfo::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MinMaxInfo *tmp = (const MinMaxInfo *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MinMaxInfo::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
MinMaxInfo::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MinMaxInfo(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: MinMaxInfo::NewInstance
//
// Purpose:
//   NewInstance method for the MinMaxInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
MinMaxInfo::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MinMaxInfo(*this);
    else
        retval = new MinMaxInfo;

    return retval;
}

// ****************************************************************************
// Method: MinMaxInfo::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MinMaxInfo::SelectAll()
{
    Select(ID_elementNum, (void *)&elementNum);
    Select(ID_domain,     (void *)&domain);
    Select(ID_mvalue,     (void *)&mvalue);
    Select(ID_coord,      (void *)coord, 3);
    Select(ID_type,       (void *)&type);
    Select(ID_matName,    (void *)&matName);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MinMaxInfo::SetElementNum(int elementNum_)
{
    elementNum = elementNum_;
    Select(ID_elementNum, (void *)&elementNum);
}

void
MinMaxInfo::SetDomain(int domain_)
{
    domain = domain_;
    Select(ID_domain, (void *)&domain);
}

void
MinMaxInfo::SetMvalue(double mvalue_)
{
    mvalue = mvalue_;
    Select(ID_mvalue, (void *)&mvalue);
}

void
MinMaxInfo::SetCoord(const double *coord_)
{
    coord[0] = coord_[0];
    coord[1] = coord_[1];
    coord[2] = coord_[2];
    Select(ID_coord, (void *)coord, 3);
}

void
MinMaxInfo::SetType(const std::string &type_)
{
    type = type_;
    Select(ID_type, (void *)&type);
}

void
MinMaxInfo::SetMatName(const std::string &matName_)
{
    matName = matName_;
    Select(ID_matName, (void *)&matName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
MinMaxInfo::GetElementNum() const
{
    return elementNum;
}

int
MinMaxInfo::GetDomain() const
{
    return domain;
}

double
MinMaxInfo::GetMvalue() const
{
    return mvalue;
}

const double *
MinMaxInfo::GetCoord() const
{
    return coord;
}

double *
MinMaxInfo::GetCoord()
{
    return coord;
}

const std::string &
MinMaxInfo::GetType() const
{
    return type;
}

std::string &
MinMaxInfo::GetType()
{
    return type;
}

const std::string &
MinMaxInfo::GetMatName() const
{
    return matName;
}

std::string &
MinMaxInfo::GetMatName()
{
    return matName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
MinMaxInfo::SelectCoord()
{
    Select(ID_coord, (void *)coord, 3);
}

void
MinMaxInfo::SelectType()
{
    Select(ID_type, (void *)&type);
}

void
MinMaxInfo::SelectMatName()
{
    Select(ID_matName, (void *)&matName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MinMaxInfo::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
MinMaxInfo::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_elementNum: return "elementNum";
    case ID_domain:     return "domain";
    case ID_mvalue:     return "mvalue";
    case ID_coord:      return "coord";
    case ID_type:       return "type";
    case ID_matName:    return "matName";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MinMaxInfo::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
MinMaxInfo::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_elementNum: return FieldType_int;
    case ID_domain:     return FieldType_int;
    case ID_mvalue:     return FieldType_double;
    case ID_coord:      return FieldType_doubleArray;
    case ID_type:       return FieldType_string;
    case ID_matName:    return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MinMaxInfo::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
MinMaxInfo::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_elementNum: return "int";
    case ID_domain:     return "int";
    case ID_mvalue:     return "double";
    case ID_coord:      return "doubleArray";
    case ID_type:       return "string";
    case ID_matName:    return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MinMaxInfo::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MinMaxInfo::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MinMaxInfo &obj = *((const MinMaxInfo*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_elementNum:
        {  // new scope
        retval = (elementNum == obj.elementNum);
        }
        break;
    case ID_domain:
        {  // new scope
        retval = (domain == obj.domain);
        }
        break;
    case ID_mvalue:
        {  // new scope
        retval = (mvalue == obj.mvalue);
        }
        break;
    case ID_coord:
        {  // new scope
        // Compare the coord arrays.
        bool coord_equal = true;
        for(int i = 0; i < 3 && coord_equal; ++i)
            coord_equal = (coord[i] == obj.coord[i]);

        retval = coord_equal;
        }
        break;
    case ID_type:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case ID_matName:
        {  // new scope
        retval = (matName == obj.matName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: MinMaxInfo::Initialize
//
//  Purpose:
//    Initialize the members.
//
//  Programmer:   Kathleen Bonnell
//  Creation:     July 1, 2004
//
//  Modifications:
//
// ****************************************************************************

void
MinMaxInfo::Initialize(const double val, const std::string &t)
{
    elementNum = -1;
    domain = -1;
    mvalue = val;
    coord[0] = 0.;
    coord[1] = 0.;
    coord[2] = 0.;
    type = t;
    matName = "NO_MAT";
}

// ****************************************************************************
//  Method: MinMaxInfo::TransformCoord
//
//  Purpose:
//    Transform the coord using the given matrix.
//
//  Programmer:   Kathleen Bonnell
//  Creation:     July 1, 2004
//
//  Modifications:
//
// ****************************************************************************

void
MinMaxInfo::TransformCoord(const avtMatrix *trans)
{
    if (trans != NULL)
    {
        avtVector v1(coord[0], coord[1], coord[2]);
        v1 = (*trans) * v1;
        coord[0] = v1.x;
        coord[1] = v1.y;
        coord[2] = v1.z;
    }
}

// ****************************************************************************
//  Method: MinMaxInfo::EquivalentForOutput
//
//  Purpose:
//    Determine equivalency for output purposes (matname not considered).
//
//  Programmer:   Kathleen Bonnell
//  Creation:     July 28, 2004
//
//  Modifications:
//
// ****************************************************************************

bool
MinMaxInfo::EquivalentForOutput(const MinMaxInfo &obj) const
{
    int i;

    // Compare the coord arrays.
    bool coord_equal = true;
    for(i = 0; i < 3 && coord_equal; ++i)
        coord_equal = (coord[i] == obj.coord[i]);

    // Create the return value
    return ((elementNum == obj.elementNum) &&
            (domain == obj.domain) &&
            (mvalue == obj.mvalue) &&
            coord_equal &&
            (type == obj.type));
}

