/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCurveAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyCurveAttributes
//
// Purpose: 
//   Attributes for the xy plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a CurveAttributes.
//
struct CurveAttributesObject
{
    PyObject_HEAD
    CurveAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCurveAttributes(int);

std::string
PyCurveAttributes_ToString(const CurveAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetShowLines())
        SNPRINTF(tmpStr, 1000, "%sshowLines = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowLines = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    if(atts->GetShowPoints())
        SNPRINTF(tmpStr, 1000, "%sshowPoints = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowPoints = 0\n", prefix);
    str += tmpStr;
    const char *symbol_names = "Point, TriangleUp, TriangleDown, Square, Circle, "
        "Plus, X";
    switch (atts->GetSymbol())
    {
      case CurveAttributes::Point:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sPoint  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::TriangleUp:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sTriangleUp  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::TriangleDown:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sTriangleDown  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::Square:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sSquare  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::Circle:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sCircle  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::Plus:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sPlus  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::X:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sX  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    const char *pointFillMode_names = "Static, Dynamic";
    switch (atts->GetPointFillMode())
    {
      case CurveAttributes::Static:
          SNPRINTF(tmpStr, 1000, "%spointFillMode = %sStatic  # %s\n", prefix, prefix, pointFillMode_names);
          str += tmpStr;
          break;
      case CurveAttributes::Dynamic:
          SNPRINTF(tmpStr, 1000, "%spointFillMode = %sDynamic  # %s\n", prefix, prefix, pointFillMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%spointStride = %d\n", prefix, atts->GetPointStride());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssymbolDensity = %d\n", prefix, atts->GetSymbolDensity());
    str += tmpStr;
    const char *curveColorSource_names = "Cycle, Custom";
    switch (atts->GetCurveColorSource())
    {
      case CurveAttributes::Cycle:
          SNPRINTF(tmpStr, 1000, "%scurveColorSource = %sCycle  # %s\n", prefix, prefix, curveColorSource_names);
          str += tmpStr;
          break;
      case CurveAttributes::Custom:
          SNPRINTF(tmpStr, 1000, "%scurveColorSource = %sCustom  # %s\n", prefix, prefix, curveColorSource_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *curveColor = atts->GetCurveColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%scurveColor = (%d, %d, %d, %d)\n", prefix, int(curveColor[0]), int(curveColor[1]), int(curveColor[2]), int(curveColor[3]));
    str += tmpStr;
    if(atts->GetShowLegend())
        SNPRINTF(tmpStr, 1000, "%sshowLegend = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowLegend = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowLabels())
        SNPRINTF(tmpStr, 1000, "%sshowLabels = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowLabels = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdesignator = \"%s\"\n", prefix, atts->GetDesignator().c_str());
    str += tmpStr;
    if(atts->GetDoBallTimeCue())
        SNPRINTF(tmpStr, 1000, "%sdoBallTimeCue = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoBallTimeCue = 0\n", prefix);
    str += tmpStr;
    const unsigned char *ballTimeCueColor = atts->GetBallTimeCueColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%sballTimeCueColor = (%d, %d, %d, %d)\n", prefix, int(ballTimeCueColor[0]), int(ballTimeCueColor[1]), int(ballTimeCueColor[2]), int(ballTimeCueColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeCueBallSize = %g\n", prefix, atts->GetTimeCueBallSize());
    str += tmpStr;
    if(atts->GetDoLineTimeCue())
        SNPRINTF(tmpStr, 1000, "%sdoLineTimeCue = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoLineTimeCue = 0\n", prefix);
    str += tmpStr;
    const unsigned char *lineTimeCueColor = atts->GetLineTimeCueColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%slineTimeCueColor = (%d, %d, %d, %d)\n", prefix, int(lineTimeCueColor[0]), int(lineTimeCueColor[1]), int(lineTimeCueColor[2]), int(lineTimeCueColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineTimeCueWidth = %d\n", prefix, atts->GetLineTimeCueWidth());
    str += tmpStr;
    if(atts->GetDoCropTimeCue())
        SNPRINTF(tmpStr, 1000, "%sdoCropTimeCue = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoCropTimeCue = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeForTimeCue = %g\n", prefix, atts->GetTimeForTimeCue());
    str += tmpStr;
    const char *fillMode_names = "NoFill, Solid, HorizontalGradient, VerticalGradient";
    switch (atts->GetFillMode())
    {
      case CurveAttributes::NoFill:
          SNPRINTF(tmpStr, 1000, "%sfillMode = %sNoFill  # %s\n", prefix, prefix, fillMode_names);
          str += tmpStr;
          break;
      case CurveAttributes::Solid:
          SNPRINTF(tmpStr, 1000, "%sfillMode = %sSolid  # %s\n", prefix, prefix, fillMode_names);
          str += tmpStr;
          break;
      case CurveAttributes::HorizontalGradient:
          SNPRINTF(tmpStr, 1000, "%sfillMode = %sHorizontalGradient  # %s\n", prefix, prefix, fillMode_names);
          str += tmpStr;
          break;
      case CurveAttributes::VerticalGradient:
          SNPRINTF(tmpStr, 1000, "%sfillMode = %sVerticalGradient  # %s\n", prefix, prefix, fillMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *fillColor1 = atts->GetFillColor1().GetColor();
    SNPRINTF(tmpStr, 1000, "%sfillColor1 = (%d, %d, %d, %d)\n", prefix, int(fillColor1[0]), int(fillColor1[1]), int(fillColor1[2]), int(fillColor1[3]));
    str += tmpStr;
    const unsigned char *fillColor2 = atts->GetFillColor2().GetColor();
    SNPRINTF(tmpStr, 1000, "%sfillColor2 = (%d, %d, %d, %d)\n", prefix, int(fillColor2[0]), int(fillColor2[1]), int(fillColor2[2]), int(fillColor2[3]));
    str += tmpStr;
    if(atts->GetPolarToCartesian())
        SNPRINTF(tmpStr, 1000, "%spolarToCartesian = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spolarToCartesian = 0\n", prefix);
    str += tmpStr;
    const char *polarCoordinateOrder_names = "R_Theta, Theta_R";
    switch (atts->GetPolarCoordinateOrder())
    {
      case CurveAttributes::R_Theta:
          SNPRINTF(tmpStr, 1000, "%spolarCoordinateOrder = %sR_Theta  # %s\n", prefix, prefix, polarCoordinateOrder_names);
          str += tmpStr;
          break;
      case CurveAttributes::Theta_R:
          SNPRINTF(tmpStr, 1000, "%spolarCoordinateOrder = %sTheta_R  # %s\n", prefix, prefix, polarCoordinateOrder_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *angleUnits_names = "Radians, Degrees";
    switch (atts->GetAngleUnits())
    {
      case CurveAttributes::Radians:
          SNPRINTF(tmpStr, 1000, "%sangleUnits = %sRadians  # %s\n", prefix, prefix, angleUnits_names);
          str += tmpStr;
          break;
      case CurveAttributes::Degrees:
          SNPRINTF(tmpStr, 1000, "%sangleUnits = %sDegrees  # %s\n", prefix, prefix, angleUnits_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
CurveAttributes_Notify(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_SetShowLines(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLines in the object.
    obj->data->SetShowLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowLines(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetShowPoints(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPoints in the object.
    obj->data->SetShowPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowPoints(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetSymbol(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the symbol in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetSymbol(CurveAttributes::SymbolTypes(ival));
    else
    {
        fprintf(stderr, "An invalid symbol value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Point, TriangleUp, TriangleDown, Square, Circle, "
                        "Plus, X.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetSymbol(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSymbol()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetPointFillMode(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointFillMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPointFillMode(CurveAttributes::FillMode(ival));
    else
    {
        fprintf(stderr, "An invalid pointFillMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Static, Dynamic.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetPointFillMode(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointFillMode()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetPointStride(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointStride in the object.
    obj->data->SetPointStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetPointStride(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointStride()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetSymbolDensity(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the symbolDensity in the object.
    obj->data->SetSymbolDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetSymbolDensity(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSymbolDensity()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetCurveColorSource(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the curveColorSource in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCurveColorSource(CurveAttributes::CurveColor(ival));
    else
    {
        fprintf(stderr, "An invalid curveColorSource value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Cycle, Custom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetCurveColorSource(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCurveColorSource()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetCurveColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the curveColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetCurveColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetCurveColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the curveColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *curveColor = obj->data->GetCurveColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(curveColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(curveColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(curveColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(curveColor[3])));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetShowLegend(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLegend in the object.
    obj->data->SetShowLegend(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowLegend(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLegend()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetShowLabels(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLabels in the object.
    obj->data->SetShowLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowLabels(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLabels()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetDesignator(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the designator in the object.
    obj->data->SetDesignator(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetDesignator(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDesignator().c_str());
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetDoBallTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doBallTimeCue in the object.
    obj->data->SetDoBallTimeCue(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetDoBallTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoBallTimeCue()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetBallTimeCueColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the ballTimeCueColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetBallTimeCueColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetBallTimeCueColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the ballTimeCueColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *ballTimeCueColor = obj->data->GetBallTimeCueColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(ballTimeCueColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(ballTimeCueColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(ballTimeCueColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(ballTimeCueColor[3])));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetTimeCueBallSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the timeCueBallSize in the object.
    obj->data->SetTimeCueBallSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetTimeCueBallSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTimeCueBallSize());
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetDoLineTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doLineTimeCue in the object.
    obj->data->SetDoLineTimeCue(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetDoLineTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoLineTimeCue()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetLineTimeCueColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the lineTimeCueColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetLineTimeCueColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetLineTimeCueColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineTimeCueColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *lineTimeCueColor = obj->data->GetLineTimeCueColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(lineTimeCueColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(lineTimeCueColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(lineTimeCueColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(lineTimeCueColor[3])));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetLineTimeCueWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineTimeCueWidth in the object.
    obj->data->SetLineTimeCueWidth((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetLineTimeCueWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineTimeCueWidth()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetDoCropTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doCropTimeCue in the object.
    obj->data->SetDoCropTimeCue(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetDoCropTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoCropTimeCue()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetTimeForTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the timeForTimeCue in the object.
    obj->data->SetTimeForTimeCue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetTimeForTimeCue(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTimeForTimeCue());
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetFillMode(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fillMode in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetFillMode(CurveAttributes::CurveFillMode(ival));
    else
    {
        fprintf(stderr, "An invalid fillMode value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "NoFill, Solid, HorizontalGradient, VerticalGradient.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetFillMode(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFillMode()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetFillColor1(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the fillColor1 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetFillColor1(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetFillColor1(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the fillColor1.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *fillColor1 = obj->data->GetFillColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(fillColor1[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(fillColor1[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(fillColor1[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(fillColor1[3])));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetFillColor2(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the fillColor2 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetFillColor2(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetFillColor2(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the fillColor2.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *fillColor2 = obj->data->GetFillColor2().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(fillColor2[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(fillColor2[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(fillColor2[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(fillColor2[3])));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetPolarToCartesian(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the polarToCartesian in the object.
    obj->data->SetPolarToCartesian(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetPolarToCartesian(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPolarToCartesian()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetPolarCoordinateOrder(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the polarCoordinateOrder in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPolarCoordinateOrder(CurveAttributes::PolarCoordinateOrder(ival));
    else
    {
        fprintf(stderr, "An invalid polarCoordinateOrder value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "R_Theta, Theta_R.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetPolarCoordinateOrder(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPolarCoordinateOrder()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetAngleUnits(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the angleUnits in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAngleUnits(CurveAttributes::AngleUnits(ival));
    else
    {
        fprintf(stderr, "An invalid angleUnits value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Radians, Degrees.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetAngleUnits(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAngleUnits()));
    return retval;
}



PyMethodDef PyCurveAttributes_methods[CURVEATTRIBUTES_NMETH] = {
    {"Notify", CurveAttributes_Notify, METH_VARARGS},
    {"SetShowLines", CurveAttributes_SetShowLines, METH_VARARGS},
    {"GetShowLines", CurveAttributes_GetShowLines, METH_VARARGS},
    {"SetLineWidth", CurveAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", CurveAttributes_GetLineWidth, METH_VARARGS},
    {"SetShowPoints", CurveAttributes_SetShowPoints, METH_VARARGS},
    {"GetShowPoints", CurveAttributes_GetShowPoints, METH_VARARGS},
    {"SetSymbol", CurveAttributes_SetSymbol, METH_VARARGS},
    {"GetSymbol", CurveAttributes_GetSymbol, METH_VARARGS},
    {"SetPointSize", CurveAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", CurveAttributes_GetPointSize, METH_VARARGS},
    {"SetPointFillMode", CurveAttributes_SetPointFillMode, METH_VARARGS},
    {"GetPointFillMode", CurveAttributes_GetPointFillMode, METH_VARARGS},
    {"SetPointStride", CurveAttributes_SetPointStride, METH_VARARGS},
    {"GetPointStride", CurveAttributes_GetPointStride, METH_VARARGS},
    {"SetSymbolDensity", CurveAttributes_SetSymbolDensity, METH_VARARGS},
    {"GetSymbolDensity", CurveAttributes_GetSymbolDensity, METH_VARARGS},
    {"SetCurveColorSource", CurveAttributes_SetCurveColorSource, METH_VARARGS},
    {"GetCurveColorSource", CurveAttributes_GetCurveColorSource, METH_VARARGS},
    {"SetCurveColor", CurveAttributes_SetCurveColor, METH_VARARGS},
    {"GetCurveColor", CurveAttributes_GetCurveColor, METH_VARARGS},
    {"SetShowLegend", CurveAttributes_SetShowLegend, METH_VARARGS},
    {"GetShowLegend", CurveAttributes_GetShowLegend, METH_VARARGS},
    {"SetShowLabels", CurveAttributes_SetShowLabels, METH_VARARGS},
    {"GetShowLabels", CurveAttributes_GetShowLabels, METH_VARARGS},
    {"SetDesignator", CurveAttributes_SetDesignator, METH_VARARGS},
    {"GetDesignator", CurveAttributes_GetDesignator, METH_VARARGS},
    {"SetDoBallTimeCue", CurveAttributes_SetDoBallTimeCue, METH_VARARGS},
    {"GetDoBallTimeCue", CurveAttributes_GetDoBallTimeCue, METH_VARARGS},
    {"SetBallTimeCueColor", CurveAttributes_SetBallTimeCueColor, METH_VARARGS},
    {"GetBallTimeCueColor", CurveAttributes_GetBallTimeCueColor, METH_VARARGS},
    {"SetTimeCueBallSize", CurveAttributes_SetTimeCueBallSize, METH_VARARGS},
    {"GetTimeCueBallSize", CurveAttributes_GetTimeCueBallSize, METH_VARARGS},
    {"SetDoLineTimeCue", CurveAttributes_SetDoLineTimeCue, METH_VARARGS},
    {"GetDoLineTimeCue", CurveAttributes_GetDoLineTimeCue, METH_VARARGS},
    {"SetLineTimeCueColor", CurveAttributes_SetLineTimeCueColor, METH_VARARGS},
    {"GetLineTimeCueColor", CurveAttributes_GetLineTimeCueColor, METH_VARARGS},
    {"SetLineTimeCueWidth", CurveAttributes_SetLineTimeCueWidth, METH_VARARGS},
    {"GetLineTimeCueWidth", CurveAttributes_GetLineTimeCueWidth, METH_VARARGS},
    {"SetDoCropTimeCue", CurveAttributes_SetDoCropTimeCue, METH_VARARGS},
    {"GetDoCropTimeCue", CurveAttributes_GetDoCropTimeCue, METH_VARARGS},
    {"SetTimeForTimeCue", CurveAttributes_SetTimeForTimeCue, METH_VARARGS},
    {"GetTimeForTimeCue", CurveAttributes_GetTimeForTimeCue, METH_VARARGS},
    {"SetFillMode", CurveAttributes_SetFillMode, METH_VARARGS},
    {"GetFillMode", CurveAttributes_GetFillMode, METH_VARARGS},
    {"SetFillColor1", CurveAttributes_SetFillColor1, METH_VARARGS},
    {"GetFillColor1", CurveAttributes_GetFillColor1, METH_VARARGS},
    {"SetFillColor2", CurveAttributes_SetFillColor2, METH_VARARGS},
    {"GetFillColor2", CurveAttributes_GetFillColor2, METH_VARARGS},
    {"SetPolarToCartesian", CurveAttributes_SetPolarToCartesian, METH_VARARGS},
    {"GetPolarToCartesian", CurveAttributes_GetPolarToCartesian, METH_VARARGS},
    {"SetPolarCoordinateOrder", CurveAttributes_SetPolarCoordinateOrder, METH_VARARGS},
    {"GetPolarCoordinateOrder", CurveAttributes_GetPolarCoordinateOrder, METH_VARARGS},
    {"SetAngleUnits", CurveAttributes_SetAngleUnits, METH_VARARGS},
    {"GetAngleUnits", CurveAttributes_GetAngleUnits, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CurveAttributes_dealloc(PyObject *v)
{
   CurveAttributesObject *obj = (CurveAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CurveAttributes_compare(PyObject *v, PyObject *w)
{
    CurveAttributes *a = ((CurveAttributesObject *)v)->data;
    CurveAttributes *b = ((CurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyCurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "showLines") == 0)
        return CurveAttributes_GetShowLines(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return CurveAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "showPoints") == 0)
        return CurveAttributes_GetShowPoints(self, NULL);
    if(strcmp(name, "symbol") == 0)
        return CurveAttributes_GetSymbol(self, NULL);
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(CurveAttributes::Point));
    if(strcmp(name, "TriangleUp") == 0)
        return PyInt_FromLong(long(CurveAttributes::TriangleUp));
    if(strcmp(name, "TriangleDown") == 0)
        return PyInt_FromLong(long(CurveAttributes::TriangleDown));
    if(strcmp(name, "Square") == 0)
        return PyInt_FromLong(long(CurveAttributes::Square));
    if(strcmp(name, "Circle") == 0)
        return PyInt_FromLong(long(CurveAttributes::Circle));
    if(strcmp(name, "Plus") == 0)
        return PyInt_FromLong(long(CurveAttributes::Plus));
    if(strcmp(name, "X") == 0)
        return PyInt_FromLong(long(CurveAttributes::X));

    if(strcmp(name, "pointSize") == 0)
        return CurveAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointFillMode") == 0)
        return CurveAttributes_GetPointFillMode(self, NULL);
    if(strcmp(name, "Static") == 0)
        return PyInt_FromLong(long(CurveAttributes::Static));
    if(strcmp(name, "Dynamic") == 0)
        return PyInt_FromLong(long(CurveAttributes::Dynamic));

    if(strcmp(name, "pointStride") == 0)
        return CurveAttributes_GetPointStride(self, NULL);
    if(strcmp(name, "symbolDensity") == 0)
        return CurveAttributes_GetSymbolDensity(self, NULL);
    if(strcmp(name, "curveColorSource") == 0)
        return CurveAttributes_GetCurveColorSource(self, NULL);
    if(strcmp(name, "Cycle") == 0)
        return PyInt_FromLong(long(CurveAttributes::Cycle));
    if(strcmp(name, "Custom") == 0)
        return PyInt_FromLong(long(CurveAttributes::Custom));

    if(strcmp(name, "curveColor") == 0)
        return CurveAttributes_GetCurveColor(self, NULL);
    if(strcmp(name, "showLegend") == 0)
        return CurveAttributes_GetShowLegend(self, NULL);
    if(strcmp(name, "showLabels") == 0)
        return CurveAttributes_GetShowLabels(self, NULL);
    if(strcmp(name, "designator") == 0)
        return CurveAttributes_GetDesignator(self, NULL);
    if(strcmp(name, "doBallTimeCue") == 0)
        return CurveAttributes_GetDoBallTimeCue(self, NULL);
    if(strcmp(name, "ballTimeCueColor") == 0)
        return CurveAttributes_GetBallTimeCueColor(self, NULL);
    if(strcmp(name, "timeCueBallSize") == 0)
        return CurveAttributes_GetTimeCueBallSize(self, NULL);
    if(strcmp(name, "doLineTimeCue") == 0)
        return CurveAttributes_GetDoLineTimeCue(self, NULL);
    if(strcmp(name, "lineTimeCueColor") == 0)
        return CurveAttributes_GetLineTimeCueColor(self, NULL);
    if(strcmp(name, "lineTimeCueWidth") == 0)
        return CurveAttributes_GetLineTimeCueWidth(self, NULL);
    if(strcmp(name, "doCropTimeCue") == 0)
        return CurveAttributes_GetDoCropTimeCue(self, NULL);
    if(strcmp(name, "timeForTimeCue") == 0)
        return CurveAttributes_GetTimeForTimeCue(self, NULL);
    if(strcmp(name, "fillMode") == 0)
        return CurveAttributes_GetFillMode(self, NULL);
    if(strcmp(name, "NoFill") == 0)
        return PyInt_FromLong(long(CurveAttributes::NoFill));
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(CurveAttributes::Solid));
    if(strcmp(name, "HorizontalGradient") == 0)
        return PyInt_FromLong(long(CurveAttributes::HorizontalGradient));
    if(strcmp(name, "VerticalGradient") == 0)
        return PyInt_FromLong(long(CurveAttributes::VerticalGradient));

    if(strcmp(name, "fillColor1") == 0)
        return CurveAttributes_GetFillColor1(self, NULL);
    if(strcmp(name, "fillColor2") == 0)
        return CurveAttributes_GetFillColor2(self, NULL);
    if(strcmp(name, "polarToCartesian") == 0)
        return CurveAttributes_GetPolarToCartesian(self, NULL);
    if(strcmp(name, "polarCoordinateOrder") == 0)
        return CurveAttributes_GetPolarCoordinateOrder(self, NULL);
    if(strcmp(name, "R_Theta") == 0)
        return PyInt_FromLong(long(CurveAttributes::R_Theta));
    if(strcmp(name, "Theta_R") == 0)
        return PyInt_FromLong(long(CurveAttributes::Theta_R));

    if(strcmp(name, "angleUnits") == 0)
        return CurveAttributes_GetAngleUnits(self, NULL);
    if(strcmp(name, "Radians") == 0)
        return PyInt_FromLong(long(CurveAttributes::Radians));
    if(strcmp(name, "Degrees") == 0)
        return PyInt_FromLong(long(CurveAttributes::Degrees));


    // Try and handle legacy fields in CurveAttributes
    if(strcmp(name, "cycleColors") == 0)
    {
        CurveAttributesObject *curveObj = (CurveAttributesObject *)self;
        bool cycleColors = curveObj->data->GetCurveColorSource() == CurveAttributes::Custom;
        return PyInt_FromLong(cycleColors?1L:0L);
    }
    // Try and handle legacy fields in CurveAttributes
    if(strcmp(name, "color") == 0)
    {
        return CurveAttributes_GetCurveColor(self, NULL);
    }
    if(strcmp(name, "RenderAsLines") == 0)
    {
        return PyInt_FromLong(0L);
    }
    if(strcmp(name, "RenderAsPoints") == 0)
    {
        return PyInt_FromLong(1L);
    }
    // lineStyle and it's possible enumerations
    bool lineStyleFound = false;
    if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true; 
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true; 
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true; 
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true; 
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true; 
    }
    if (lineStyleFound)
    {
        fprintf(stdout, "lineStyle is no longer a valid Curve "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyCurveAttributes_methods, self, name);
}

int
PyCurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "showLines") == 0)
        obj = CurveAttributes_SetShowLines(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = CurveAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "showPoints") == 0)
        obj = CurveAttributes_SetShowPoints(self, tuple);
    else if(strcmp(name, "symbol") == 0)
        obj = CurveAttributes_SetSymbol(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = CurveAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "pointFillMode") == 0)
        obj = CurveAttributes_SetPointFillMode(self, tuple);
    else if(strcmp(name, "pointStride") == 0)
        obj = CurveAttributes_SetPointStride(self, tuple);
    else if(strcmp(name, "symbolDensity") == 0)
        obj = CurveAttributes_SetSymbolDensity(self, tuple);
    else if(strcmp(name, "curveColorSource") == 0)
        obj = CurveAttributes_SetCurveColorSource(self, tuple);
    else if(strcmp(name, "curveColor") == 0)
        obj = CurveAttributes_SetCurveColor(self, tuple);
    else if(strcmp(name, "showLegend") == 0)
        obj = CurveAttributes_SetShowLegend(self, tuple);
    else if(strcmp(name, "showLabels") == 0)
        obj = CurveAttributes_SetShowLabels(self, tuple);
    else if(strcmp(name, "designator") == 0)
        obj = CurveAttributes_SetDesignator(self, tuple);
    else if(strcmp(name, "doBallTimeCue") == 0)
        obj = CurveAttributes_SetDoBallTimeCue(self, tuple);
    else if(strcmp(name, "ballTimeCueColor") == 0)
        obj = CurveAttributes_SetBallTimeCueColor(self, tuple);
    else if(strcmp(name, "timeCueBallSize") == 0)
        obj = CurveAttributes_SetTimeCueBallSize(self, tuple);
    else if(strcmp(name, "doLineTimeCue") == 0)
        obj = CurveAttributes_SetDoLineTimeCue(self, tuple);
    else if(strcmp(name, "lineTimeCueColor") == 0)
        obj = CurveAttributes_SetLineTimeCueColor(self, tuple);
    else if(strcmp(name, "lineTimeCueWidth") == 0)
        obj = CurveAttributes_SetLineTimeCueWidth(self, tuple);
    else if(strcmp(name, "doCropTimeCue") == 0)
        obj = CurveAttributes_SetDoCropTimeCue(self, tuple);
    else if(strcmp(name, "timeForTimeCue") == 0)
        obj = CurveAttributes_SetTimeForTimeCue(self, tuple);
    else if(strcmp(name, "fillMode") == 0)
        obj = CurveAttributes_SetFillMode(self, tuple);
    else if(strcmp(name, "fillColor1") == 0)
        obj = CurveAttributes_SetFillColor1(self, tuple);
    else if(strcmp(name, "fillColor2") == 0)
        obj = CurveAttributes_SetFillColor2(self, tuple);
    else if(strcmp(name, "polarToCartesian") == 0)
        obj = CurveAttributes_SetPolarToCartesian(self, tuple);
    else if(strcmp(name, "polarCoordinateOrder") == 0)
        obj = CurveAttributes_SetPolarCoordinateOrder(self, tuple);
    else if(strcmp(name, "angleUnits") == 0)
        obj = CurveAttributes_SetAngleUnits(self, tuple);

   // Try and handle legacy fields in CurveAttributes
    if(obj == NULL)
    {
        CurveAttributesObject *CurveObj = (CurveAttributesObject *)self;
        if(strcmp(name, "color") == 0)
        {
            obj = CurveAttributes_SetCurveColor(self, tuple);
        }
        if(strcmp(name, "cycleColors") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                CurveObj->data->SetCurveColorSource(CurveAttributes::Custom);
            else
                CurveObj->data->SetCurveColorSource(CurveAttributes::Cycle);
    
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        if(strcmp(name, "renderMode") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
            {
                CurveObj->data->SetShowLines(true);
                CurveObj->data->SetShowPoints(false);
            }
            else
            {
                CurveObj->data->SetShowLines(false);
                CurveObj->data->SetShowPoints(true);
            }
    
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
CurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)v;
    fprintf(fp, "%s", PyCurveAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CurveAttributes_str(PyObject *v)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)v;
    return PyString_FromString(PyCurveAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CurveAttributes_Purpose = "Attributes for the xy plot";
#else
static char *CurveAttributes_Purpose = "Attributes for the xy plot";
#endif

//
// The type description structure
//
static PyTypeObject CurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CurveAttributes",                    // tp_name
    sizeof(CurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CurveAttributes_dealloc,  // tp_dealloc
    (printfunc)CurveAttributes_print,     // tp_print
    (getattrfunc)PyCurveAttributes_getattr, // tp_getattr
    (setattrfunc)PyCurveAttributes_setattr, // tp_setattr
    (cmpfunc)CurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CurveAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CurveAttributes *defaultAtts = 0;
static CurveAttributes *currentAtts = 0;

static PyObject *
NewCurveAttributes(int useCurrent)
{
    CurveAttributesObject *newObject;
    newObject = PyObject_NEW(CurveAttributesObject, &CurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CurveAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CurveAttributes(*defaultAtts);
    else
        newObject->data = new CurveAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCurveAttributes(const CurveAttributes *attr)
{
    CurveAttributesObject *newObject;
    newObject = PyObject_NEW(CurveAttributesObject, &CurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CurveAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CurveAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCurveAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CurveAttributesMethods[] = {
    {"CurveAttributes", CurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CurveAttributesObserver = 0;

std::string
PyCurveAttributes_GetLogString()
{
    std::string s("CurveAtts = CurveAttributes()\n");
    if(currentAtts != 0)
        s += PyCurveAttributes_ToString(currentAtts, "CurveAtts.");
    return s;
}

static void
PyCurveAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CurveAtts = CurveAttributes()\n");
        s += PyCurveAttributes_ToString(currentAtts, "CurveAtts.");
        cb(s);
    }
}

void
PyCurveAttributes_StartUp(CurveAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CurveAttributesObserver == 0)
    {
        CurveAttributesObserver = new ObserverToCallback(subj,
            PyCurveAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CurveAttributesObserver;
    CurveAttributesObserver = 0;
}

PyMethodDef *
PyCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CurveAttributesMethods;
}

bool
PyCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CurveAttributesType);
}

CurveAttributes *
PyCurveAttributes_FromPyObject(PyObject *obj)
{
    CurveAttributesObject *obj2 = (CurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCurveAttributes_New()
{
    return NewCurveAttributes(0);
}

PyObject *
PyCurveAttributes_Wrap(const CurveAttributes *attr)
{
    return WrapCurveAttributes(attr);
}

void
PyCurveAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CurveAttributesObject *obj2 = (CurveAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCurveAttributes_SetDefaults(const CurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CurveAttributes(*atts);
}

