/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyFileOpenOptions.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyDBOptionsAttributes.h>

// ****************************************************************************
// Module: PyFileOpenOptions
//
// Purpose: 
//   This class contains the file opening options for all the database plugins.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a FileOpenOptions.
//
struct FileOpenOptionsObject
{
    PyObject_HEAD
    FileOpenOptions *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewFileOpenOptions(int);

std::string
PyFileOpenOptions_ToString(const FileOpenOptions *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &typeNames = atts->GetTypeNames();
        SNPRINTF(tmpStr, 1000, "%stypeNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < typeNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", typeNames[i].c_str());
            str += tmpStr;
            if(i < typeNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &typeIDs = atts->GetTypeIDs();
        SNPRINTF(tmpStr, 1000, "%stypeIDs = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < typeIDs.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", typeIDs[i].c_str());
            str += tmpStr;
            if(i < typeIDs.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    { // new scope
        int index = 0;
        // Create string representation of openOptions from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetOpenOptions().begin(); pos != atts->GetOpenOptions().end(); ++pos, ++index)
        {
            const DBOptionsAttributes *current = (const DBOptionsAttributes *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetOpenOptions(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyDBOptionsAttributes_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#openOptions does not contain any DBOptionsAttributes objects.\n";
    }
    {   const intVector &Enabled = atts->GetEnabled();
        SNPRINTF(tmpStr, 1000, "%sEnabled = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < Enabled.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", Enabled[i]);
            str += tmpStr;
            if(i < Enabled.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &preferredIDs = atts->GetPreferredIDs();
        SNPRINTF(tmpStr, 1000, "%spreferredIDs = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < preferredIDs.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", preferredIDs[i].c_str());
            str += tmpStr;
            if(i < preferredIDs.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
FileOpenOptions_Notify(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FileOpenOptions_SetTypeNames(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;

    stringVector  &vec = obj->data->GetTypeNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the typeNames in the object as modified.
    obj->data->SelectTypeNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FileOpenOptions_GetTypeNames(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    // Allocate a tuple the with enough entries to hold the typeNames.
    const stringVector &typeNames = obj->data->GetTypeNames();
    PyObject *retval = PyTuple_New(typeNames.size());
    for(size_t i = 0; i < typeNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(typeNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
FileOpenOptions_SetTypeIDs(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;

    stringVector  &vec = obj->data->GetTypeIDs();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the typeIDs in the object as modified.
    obj->data->SelectTypeIDs();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FileOpenOptions_GetTypeIDs(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    // Allocate a tuple the with enough entries to hold the typeIDs.
    const stringVector &typeIDs = obj->data->GetTypeIDs();
    PyObject *retval = PyTuple_New(typeIDs.size());
    for(size_t i = 0; i < typeIDs.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(typeIDs[i].c_str()));
    return retval;
}

/*static*/ PyObject *
FileOpenOptions_GetOpenOptions(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetOpenOptions().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetOpenOptions().size() == 0)
            SNPRINTF(msg, 400, "In FileOpenOptions::GetOpenOptions : The index %d is invalid because openOptions is empty.", index);
        else
            SNPRINTF(msg, 400, "In FileOpenOptions::GetOpenOptions : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetOpenOptions().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyDBOptionsAttributes_Wrap(&obj->data->GetOpenOptions(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyDBOptionsAttributes_SetParent(retval, self);

    return retval;
}

PyObject *
FileOpenOptions_GetNumOpenOptions(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    return PyInt_FromLong((long)obj->data->GetOpenOptions().size());
}

PyObject *
FileOpenOptions_AddOpenOptions(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyDBOptionsAttributes_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The FileOpenOptions::AddOpenOptions method only accepts DBOptionsAttributes objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    DBOptionsAttributes *newData = PyDBOptionsAttributes_FromPyObject(element);
    obj->data->AddOpenOptions(*newData);
    obj->data->SelectOpenOptions();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FileOpenOptions_Remove_One_OpenOptions(PyObject *self, int index)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveOpenOptions() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetOpenOptions();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectOpenOptions();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
FileOpenOptions_RemoveOpenOptions(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    if(index < 0 || index >= obj->data->GetNumOpenOptions())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In FileOpenOptions::RemoveOpenOptions : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return FileOpenOptions_Remove_One_OpenOptions(self, index);
}

PyObject *
FileOpenOptions_ClearOpenOptions(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    int n = obj->data->GetNumOpenOptions();
    for(int i = 0; i < n; ++i)
    {
        FileOpenOptions_Remove_One_OpenOptions(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FileOpenOptions_SetEnabled(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;

    intVector  &vec = obj->data->GetEnabled();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the Enabled in the object as modified.
    obj->data->SelectEnabled();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FileOpenOptions_GetEnabled(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    // Allocate a tuple the with enough entries to hold the Enabled.
    const intVector &Enabled = obj->data->GetEnabled();
    PyObject *retval = PyTuple_New(Enabled.size());
    for(size_t i = 0; i < Enabled.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(Enabled[i])));
    return retval;
}

/*static*/ PyObject *
FileOpenOptions_SetPreferredIDs(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;

    stringVector  &vec = obj->data->GetPreferredIDs();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the preferredIDs in the object as modified.
    obj->data->SelectPreferredIDs();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FileOpenOptions_GetPreferredIDs(PyObject *self, PyObject *args)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)self;
    // Allocate a tuple the with enough entries to hold the preferredIDs.
    const stringVector &preferredIDs = obj->data->GetPreferredIDs();
    PyObject *retval = PyTuple_New(preferredIDs.size());
    for(size_t i = 0; i < preferredIDs.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(preferredIDs[i].c_str()));
    return retval;
}



PyMethodDef PyFileOpenOptions_methods[FILEOPENOPTIONS_NMETH] = {
    {"Notify", FileOpenOptions_Notify, METH_VARARGS},
    {"SetTypeNames", FileOpenOptions_SetTypeNames, METH_VARARGS},
    {"GetTypeNames", FileOpenOptions_GetTypeNames, METH_VARARGS},
    {"SetTypeIDs", FileOpenOptions_SetTypeIDs, METH_VARARGS},
    {"GetTypeIDs", FileOpenOptions_GetTypeIDs, METH_VARARGS},
    {"GetOpenOptions", FileOpenOptions_GetOpenOptions, METH_VARARGS},
    {"GetNumOpenOptions", FileOpenOptions_GetNumOpenOptions, METH_VARARGS},
    {"AddOpenOptions", FileOpenOptions_AddOpenOptions, METH_VARARGS},
    {"RemoveOpenOptions", FileOpenOptions_RemoveOpenOptions, METH_VARARGS},
    {"ClearOpenOptions", FileOpenOptions_ClearOpenOptions, METH_VARARGS},
    {"SetEnabled", FileOpenOptions_SetEnabled, METH_VARARGS},
    {"GetEnabled", FileOpenOptions_GetEnabled, METH_VARARGS},
    {"SetPreferredIDs", FileOpenOptions_SetPreferredIDs, METH_VARARGS},
    {"GetPreferredIDs", FileOpenOptions_GetPreferredIDs, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FileOpenOptions_dealloc(PyObject *v)
{
   FileOpenOptionsObject *obj = (FileOpenOptionsObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
FileOpenOptions_compare(PyObject *v, PyObject *w)
{
    FileOpenOptions *a = ((FileOpenOptionsObject *)v)->data;
    FileOpenOptions *b = ((FileOpenOptionsObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyFileOpenOptions_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "typeNames") == 0)
        return FileOpenOptions_GetTypeNames(self, NULL);
    if(strcmp(name, "typeIDs") == 0)
        return FileOpenOptions_GetTypeIDs(self, NULL);
    if(strcmp(name, "openOptions") == 0)
        return FileOpenOptions_GetOpenOptions(self, NULL);
    if(strcmp(name, "Enabled") == 0)
        return FileOpenOptions_GetEnabled(self, NULL);
    if(strcmp(name, "preferredIDs") == 0)
        return FileOpenOptions_GetPreferredIDs(self, NULL);

    return Py_FindMethod(PyFileOpenOptions_methods, self, name);
}

int
PyFileOpenOptions_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "typeNames") == 0)
        obj = FileOpenOptions_SetTypeNames(self, tuple);
    else if(strcmp(name, "typeIDs") == 0)
        obj = FileOpenOptions_SetTypeIDs(self, tuple);
    else if(strcmp(name, "Enabled") == 0)
        obj = FileOpenOptions_SetEnabled(self, tuple);
    else if(strcmp(name, "preferredIDs") == 0)
        obj = FileOpenOptions_SetPreferredIDs(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
FileOpenOptions_print(PyObject *v, FILE *fp, int flags)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)v;
    fprintf(fp, "%s", PyFileOpenOptions_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
FileOpenOptions_str(PyObject *v)
{
    FileOpenOptionsObject *obj = (FileOpenOptionsObject *)v;
    return PyString_FromString(PyFileOpenOptions_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *FileOpenOptions_Purpose = "This class contains the file opening options for all the database plugins.";
#else
static char *FileOpenOptions_Purpose = "This class contains the file opening options for all the database plugins.";
#endif

//
// The type description structure
//
static PyTypeObject FileOpenOptionsType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FileOpenOptions",                    // tp_name
    sizeof(FileOpenOptionsObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FileOpenOptions_dealloc,  // tp_dealloc
    (printfunc)FileOpenOptions_print,     // tp_print
    (getattrfunc)PyFileOpenOptions_getattr, // tp_getattr
    (setattrfunc)PyFileOpenOptions_setattr, // tp_setattr
    (cmpfunc)FileOpenOptions_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FileOpenOptions_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FileOpenOptions_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FileOpenOptions *defaultAtts = 0;
static FileOpenOptions *currentAtts = 0;

static PyObject *
NewFileOpenOptions(int useCurrent)
{
    FileOpenOptionsObject *newObject;
    newObject = PyObject_NEW(FileOpenOptionsObject, &FileOpenOptionsType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new FileOpenOptions(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new FileOpenOptions(*defaultAtts);
    else
        newObject->data = new FileOpenOptions;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapFileOpenOptions(const FileOpenOptions *attr)
{
    FileOpenOptionsObject *newObject;
    newObject = PyObject_NEW(FileOpenOptionsObject, &FileOpenOptionsType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FileOpenOptions *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FileOpenOptions_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewFileOpenOptions(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FileOpenOptionsMethods[] = {
    {"FileOpenOptions", FileOpenOptions_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FileOpenOptionsObserver = 0;

std::string
PyFileOpenOptions_GetLogString()
{
    std::string s("FileOpenOptions = FileOpenOptions()\n");
    if(currentAtts != 0)
        s += PyFileOpenOptions_ToString(currentAtts, "FileOpenOptions.");
    return s;
}

static void
PyFileOpenOptions_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("FileOpenOptions = FileOpenOptions()\n");
        s += PyFileOpenOptions_ToString(currentAtts, "FileOpenOptions.");
        cb(s);
    }
}

void
PyFileOpenOptions_StartUp(FileOpenOptions *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyFileOpenOptions_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FileOpenOptionsObserver == 0)
    {
        FileOpenOptionsObserver = new ObserverToCallback(subj,
            PyFileOpenOptions_CallLogRoutine, (void *)data);
    }

}

void
PyFileOpenOptions_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FileOpenOptionsObserver;
    FileOpenOptionsObserver = 0;
}

PyMethodDef *
PyFileOpenOptions_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FileOpenOptionsMethods;
}

bool
PyFileOpenOptions_Check(PyObject *obj)
{
    return (obj->ob_type == &FileOpenOptionsType);
}

FileOpenOptions *
PyFileOpenOptions_FromPyObject(PyObject *obj)
{
    FileOpenOptionsObject *obj2 = (FileOpenOptionsObject *)obj;
    return obj2->data;
}

PyObject *
PyFileOpenOptions_New()
{
    return NewFileOpenOptions(0);
}

PyObject *
PyFileOpenOptions_Wrap(const FileOpenOptions *attr)
{
    return WrapFileOpenOptions(attr);
}

void
PyFileOpenOptions_SetParent(PyObject *obj, PyObject *parent)
{
    FileOpenOptionsObject *obj2 = (FileOpenOptionsObject *)obj;
    obj2->parent = parent;
}

void
PyFileOpenOptions_SetDefaults(const FileOpenOptions *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new FileOpenOptions(*atts);
}

